/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.testing;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import lombok.NonNull;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.codec._DocumentFactories;
import org.w3c.dom.Document;

public final class _DocumentTester {
    public static void assertXmlEqualsIgnoreOrder(@NonNull String xml1, @NonNull String xml2) {
        if (xml1 == null) {
            throw new NullPointerException("xml1 is marked non-null but is null");
        }
        if (xml2 == null) {
            throw new NullPointerException("xml2 is marked non-null but is null");
        }
        Document doc1 = _DocumentFactories.parseDocument(xml1);
        Document doc2 = _DocumentFactories.parseDocument(xml2);
        doc1.normalizeDocument();
        doc2.normalizeDocument();
        _Assert.assertTrue(doc1.isEqualNode(doc2));
    }

    public static void assertJsonEqualsIgnoreOrder(@NonNull String json1, @NonNull String json2) {
        if (json1 == null) {
            throw new NullPointerException("json1 is marked non-null but is null");
        }
        if (json2 == null) {
            throw new NullPointerException("json2 is marked non-null but is null");
        }
        ObjectMapper mapper = new ObjectMapper();
        _Assert.assertEquals(mapper.readTree(json1), mapper.readTree(json2));
    }

    public static void assertYamlEqualsIgnoreOrder(@NonNull String yaml1, @NonNull String yaml2) {
        if (yaml1 == null) {
            throw new NullPointerException("yaml1 is marked non-null but is null");
        }
        if (yaml2 == null) {
            throw new NullPointerException("yaml2 is marked non-null but is null");
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        _Assert.assertEquals(mapper.readTree(yaml1), mapper.readTree(yaml2));
    }

    private _DocumentTester() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

