/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.causeway.commons.internal.base._Casts;

class _Arrays_CollectorUnknownSize<T>
implements Collector<T, List<T>, T[]> {
    private final Class<T> componentType;

    _Arrays_CollectorUnknownSize(Class<T> componentType) {
        this.componentType = componentType;
    }

    @Override
    public Supplier<List<T>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<T>, T> accumulator() {
        return List::add;
    }

    @Override
    public BinaryOperator<List<T>> combiner() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    @Override
    public Function<List<T>, T[]> finisher() {
        Object[] arg = (Object[])_Casts.uncheckedCast(Array.newInstance(this.componentType, 0));
        return list -> list.toArray(arg);
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }
}

