/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal._Constants;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Arrays;
import org.apache.causeway.commons.internal.functions._Predicates;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class _Reflect {
    public static boolean methodsSame(Method a, Method b) {
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        if (a.getParameterCount() != b.getParameterCount()) {
            return false;
        }
        if (!_Arrays.testAllMatch(a.getParameters(), b.getParameters(), (p1, p2) -> p1.getType().equals(p2.getType()))) {
            return false;
        }
        return _Reflect.shareSameTypeHierarchy(a.getReturnType(), b.getReturnType());
    }

    public static boolean methodsWeaklySame(Method a, Method b) {
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        if (a.getParameterCount() != b.getParameterCount()) {
            return false;
        }
        if (a.getParameterCount() > 0 && (a.isBridge() || b.isBridge() ? !_Arrays.testAllMatch(a.getParameters(), b.getParameters(), (p1, p2) -> _Reflect.shareSameTypeHierarchy(p1.getType(), p2.getType())) : !_Arrays.testAllMatch(a.getParameters(), b.getParameters(), (p1, p2) -> p1.getType().equals(p2.getType())))) {
            return false;
        }
        return _Reflect.shareSameTypeHierarchy(a.getReturnType(), b.getReturnType());
    }

    public static boolean shareSameTypeHierarchy(@NonNull Class<?> a, @NonNull Class<?> b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return a.isAssignableFrom(b) || b.isAssignableFrom(a);
    }

    public static boolean shareSameTypeHierarchy(@NonNull Method a, @NonNull Method b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return _Reflect.shareSameTypeHierarchy(a.getDeclaringClass(), b.getDeclaringClass());
    }

    public static int methodWeakCompare(Method a, Method b) {
        int c = a.getName().compareTo(b.getName());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(a.getParameterCount(), b.getParameterCount());
        if (c != 0) {
            return c;
        }
        Parameter[] paramsA = a.getParameters();
        Parameter[] paramsB = b.getParameters();
        for (int i = 0; i < a.getParameterCount(); ++i) {
            c = _Reflect.typesCompare(paramsA[i].getType(), paramsB[i].getType());
            if (c == 0) continue;
            return c;
        }
        c = _Reflect.typesCompare(a.getReturnType(), b.getReturnType());
        if (c != 0) {
            return _Reflect.shareSameTypeHierarchy(a.getReturnType(), b.getReturnType()) ? 0 : c;
        }
        return 0;
    }

    public static int typesCompare(Class<?> a, Class<?> b) {
        return a.getName().compareTo(b.getName());
    }

    public static boolean canAccess(@Nullable AccessibleObject member, @Nullable Object obj) {
        return member != null && member.canAccess(obj);
    }

    public static boolean isPublicNonSynthetic(@Nullable Member member) {
        return member != null && Modifier.isPublic(member.getModifiers()) && !member.isSynthetic();
    }

    public static <T extends Member> Predicate<T> withName(@NonNull String memberName) {
        if (memberName == null) {
            throw new NullPointerException("memberName is marked non-null but is null");
        }
        return m -> m != null && memberName.equals(m.getName());
    }

    public static <T extends Member> Predicate<T> withPrefix(@NonNull String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        return m -> m != null && m.getName().startsWith(prefix);
    }

    public static Predicate<Method> withMethodParametersCount(int count) {
        return m -> m != null && m.getParameterTypes().length == count;
    }

    public static <T> Predicate<Field> withTypeAssignableTo(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return f -> f != null && type.isAssignableFrom(f.getType());
    }

    public static Stream<Field> streamFields(@Nullable Class<?> type, boolean ignoreAccess) {
        if (type == null) {
            return Stream.empty();
        }
        if (ignoreAccess) {
            return _NullSafe.stream(type.getDeclaredFields());
        }
        return _NullSafe.stream(type.getFields());
    }

    public static Stream<Field> streamAllFields(@Nullable Class<?> type, boolean ignoreAccess) {
        return _Reflect.streamTypeHierarchy(type, InterfacePolicy.EXCLUDE).filter(t -> !Object.class.equals(t)).flatMap(t -> _Reflect.streamFields(t, ignoreAccess));
    }

    public static Stream<Method> streamMethods(@Nullable Class<?> type, boolean ignoreAccess) {
        if (type == null) {
            return Stream.empty();
        }
        if (ignoreAccess) {
            return _NullSafe.stream(type.getDeclaredMethods());
        }
        return _NullSafe.stream(type.getMethods());
    }

    public static Stream<Method> streamInheritedMethods(Method method) {
        return _Reflect.streamAllMethods(method.getDeclaringClass(), true).filter(candidateMethod -> _Reflect.methodsSame(candidateMethod, method));
    }

    public static Stream<Method> streamAllMethods(@Nullable Class<?> type, boolean ignoreAccess) {
        return _Reflect.streamTypeHierarchy(type, InterfacePolicy.INCLUDE).filter(t -> !t.equals(Object.class)).flatMap(t -> _Reflect.streamMethods(t, ignoreAccess));
    }

    public static Stream<Class<?>> streamTypeHierarchy(@Nullable Class<?> type, @NonNull InterfacePolicy interfacePolicy) {
        if (interfacePolicy == null) {
            throw new NullPointerException("interfacePolicy is marked non-null but is null");
        }
        return interfacePolicy.isIncludeInterfaces() ? Stream.concat(Stream.iterate(type, Objects::nonNull, Class::getSuperclass), ClassUtils.getAllInterfacesForClassAsSet(type).stream()) : Stream.iterate(type, Objects::nonNull, Class::getSuperclass);
    }

    public static <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annotationClass) {
        Class<?>[] interfaces;
        if (cls == null) {
            return null;
        }
        T annotation = cls.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            try {
                T annotationFromSuperclass = _Reflect.getAnnotation(superclass, annotationClass);
                if (annotationFromSuperclass != null) {
                    return annotationFromSuperclass;
                }
            }
            catch (SecurityException annotationFromSuperclass) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            T annotationFromInterface = _Reflect.getAnnotation(iface, annotationClass);
            if (annotationFromInterface == null) continue;
            return annotationFromInterface;
        }
        return null;
    }

    public static <A extends Annotation> A getAnnotation(@NonNull Method method, @NonNull Class<A> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (annotationCls == null) {
            throw new NullPointerException("annotationCls is marked non-null but is null");
        }
        if (!ignoreAccess && !_Reflect.isPublicNonSynthetic(method)) {
            return null;
        }
        if (searchSupers) {
            return (A)AnnotationUtils.findAnnotation((Method)method, annotationCls);
        }
        return (A)AnnotationUtils.getAnnotation((Method)method, annotationCls);
    }

    public static boolean containsAnnotation(@Nullable Class<?> cls, @Nullable String annotationName) {
        if (cls == null || _Strings.isEmpty(annotationName)) {
            return false;
        }
        for (Annotation annot : cls.getAnnotations()) {
            if (!annot.annotationType().getName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static Stream<PropertyDescriptor> streamGetters(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return Stream.of(Introspector.getBeanInfo(cls, Object.class).getPropertyDescriptors()).filter(pd -> pd.getReadMethod() != null);
    }

    public static Map<String, Method> getGettersByName(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return _Reflect.streamGetters(cls).collect(Collectors.toMap(FeatureDescriptor::getName, PropertyDescriptor::getReadMethod));
    }

    public static Method getGetter(Class<?> cls, String propertyName) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
            if (!pd.getName().equals(propertyName)) continue;
            return pd.getReadMethod();
        }
        return null;
    }

    public static Object readFromGetterOn(@NonNull Method getter, @NonNull Object target) {
        if (getter == null) {
            throw new NullPointerException("getter is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return getter.invoke(target, new Object[0]);
    }

    public static Method getSetter(Class<?> cls, String propertyName) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
            if (!pd.getName().equals(propertyName)) continue;
            return pd.getWriteMethod();
        }
        return null;
    }

    public static void writeToSetterOn(@NonNull Method setter, @NonNull Object target, @NonNull Object value) {
        if (setter == null) {
            throw new NullPointerException("setter is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        setter.invoke(target, value);
    }

    public static Object getFieldOn(@NonNull Field field, @NonNull Object target) throws IllegalArgumentException, IllegalAccessException {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (_Reflect.canAccess(field, target)) {
            return field.get(target);
        }
        try {
            field.setAccessible(true);
            Object object = field.get(target);
            return object;
        }
        finally {
            field.setAccessible(false);
        }
    }

    public static void setFieldOn(@NonNull Field field, @NonNull Object target, Object fieldValue) throws IllegalArgumentException, IllegalAccessException {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (_Reflect.canAccess(field, target)) {
            field.set(target, fieldValue);
            return;
        }
        try {
            field.setAccessible(true);
            field.set(target, fieldValue);
        }
        finally {
            field.setAccessible(false);
        }
    }

    public static Try<Object> invokeMethodOn(@NonNull Method method, @NonNull Object target, Object ... args) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return Try.call(() -> {
            if (_Reflect.canAccess(method, target)) {
                return method.invoke(target, args);
            }
            try {
                method.setAccessible(true);
                Object object = method.invoke(target, args);
                return object;
            }
            finally {
                method.setAccessible(false);
            }
        });
    }

    public static <T> Try<T> invokeConstructor(@NonNull Constructor<T> constructor, Object ... args) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        return Try.call(() -> {
            if (_Reflect.canAccess(constructor, null)) {
                return constructor.newInstance(args);
            }
            try {
                constructor.setAccessible(true);
                Object t = constructor.newInstance(args);
                return t;
            }
            finally {
                constructor.setAccessible(false);
            }
        });
    }

    public static Can<Constructor<?>> getDeclaredConstructors(Class<?> cls) {
        return Can.ofArray(cls.getDeclaredConstructors());
    }

    public static Can<Constructor<?>> getPublicConstructors(Class<?> cls) {
        return Can.ofArray(cls.getConstructors());
    }

    public static boolean methodSignatureMatch(Class<?>[] parameterTypes, Class<?>[] matchingParamTypes) {
        int aSize = _NullSafe.size(parameterTypes);
        int bSize = _NullSafe.size(matchingParamTypes);
        if (aSize == 0 && bSize == 0) {
            return true;
        }
        if (aSize != bSize) {
            return false;
        }
        for (int c = 0; c < aSize; ++c) {
            if (Objects.equals(parameterTypes[c], matchingParamTypes[c])) continue;
            return false;
        }
        return true;
    }

    public static boolean methodSignatureAssignableTo(Class<?>[] parameterTypes, Class<?>[] requiredParamTypes) {
        int aSize = _NullSafe.size(parameterTypes);
        int bSize = _NullSafe.size(requiredParamTypes);
        if (aSize == 0 && bSize == 0) {
            return true;
        }
        if (aSize != bSize) {
            return false;
        }
        for (int c = 0; c < aSize; ++c) {
            if (requiredParamTypes[c].isAssignableFrom(parameterTypes[c])) continue;
            return false;
        }
        return true;
    }

    public static boolean methodSignatureWeaklyMatch(Class<?>[] parameterTypes, Class<?>[] otherParamTypes) {
        int aSize = _NullSafe.size(parameterTypes);
        int bSize = _NullSafe.size(otherParamTypes);
        if (aSize == 0 && bSize == 0) {
            return true;
        }
        if (aSize != bSize) {
            return false;
        }
        return _Arrays.testAllMatch(parameterTypes, otherParamTypes, (p1, p2) -> p1.isAssignableFrom((Class<?>)p2)) || _Arrays.testAllMatch(parameterTypes, otherParamTypes, (p1, p2) -> p2.isAssignableFrom((Class<?>)p1));
    }

    public static Method guardAgainstSynthetic(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        _Assert.assertFalse(method.isSynthetic(), () -> String.format("unsupported synthetic method %s", method));
        return method;
    }

    public static boolean isNonFinalObjectMethod(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        for (Method m : _Constants.nonFinalObjectMethods) {
            if (!_Reflect.methodsSame(m, method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverwrittenToString(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return method.getName().equals("toString") && method.getParameterCount() == 0 && !_Reflect.isJavaApiClass(method.getDeclaringClass());
    }

    public static boolean isJavaApiClass(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        String className = cls.getName();
        return className.startsWith("java.") || className.startsWith("sun.");
    }

    public static String methodToShortString(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return method.getName() + "(" + Stream.of(method.getParameterTypes()).map(parameterType -> parameterType.getTypeName()).collect(Collectors.joining(", ")) + ")";
    }

    public static String methodSummary(@Nullable Method method) {
        return _Reflect.methodSummary(method, cls -> cls.getSimpleName().substring(0, 3));
    }

    public static String methodSummary(@Nullable Method method, Function<Class<?>, String> typeToShortName) {
        return Optional.ofNullable(method).map(Method::getName).map(name -> String.format("%s(%s)%s%s%s%s", name, _NullSafe.stream(method.getParameterTypes()).map(typeToShortName).collect(Collectors.joining(",")), _Reflect.hasGenericParam(method) ? "p" : "", _Reflect.hasGenericReturn(method) ? "r" : "", method.isSynthetic() ? "s" : "", method.isBridge() ? "b" : "")).orElse("-");
    }

    public static boolean isNonStaticInnerMethod(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return ClassUtils.isInnerClass(method.getDeclaringClass());
    }

    public static boolean hasGenericBounds(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return _Reflect.hasGenericReturn(method) || _Reflect.hasGenericParam(method);
    }

    public static boolean hasGenericReturn(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return method.getGenericReturnType() instanceof TypeVariable;
    }

    public static boolean hasGenericParam(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            if (!(genericParameterTypes[i] instanceof TypeVariable)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> mostSpecificType(Class<?> a, Class<?> b) {
        if (a.equals(b)) {
            return b;
        }
        _Assert.assertTrue(_Reflect.shareSameTypeHierarchy(a, b), () -> String.format("declared types %s and %s don't share the same type hierarchy", a, b));
        return a.isAssignableFrom(b) ? b : a;
    }

    static Optional<Field> fieldForGetter(Method getterCandidate) {
        return Optional.ofNullable(_Reflect.findFieldForGetter(getterCandidate));
    }

    private static Field findFieldForGetter(Method getterCandidate) {
        if (ReflectionUtils.isObjectMethod((Method)getterCandidate)) {
            return null;
        }
        String fieldNameCandidate = _Reflect.fieldNameForGetter(getterCandidate);
        if (fieldNameCandidate == null) {
            return null;
        }
        Class<?> declaringClass = getterCandidate.getDeclaringClass();
        return ReflectionUtils.findField(declaringClass, (String)fieldNameCandidate);
    }

    private static String fieldNameForGetter(Method getter) {
        if (getter.getParameterCount() > 0) {
            return null;
        }
        if (getter.getReturnType() == Void.TYPE) {
            return null;
        }
        String methodName = getter.getName();
        String fieldName = null;
        if (methodName.startsWith("is") && methodName.length() > 2) {
            fieldName = methodName.substring(2);
        } else if (methodName.startsWith("get") && methodName.length() > 3) {
            fieldName = methodName.substring(3);
        } else {
            return null;
        }
        return _Strings.decapitalize(fieldName);
    }

    @Generated
    private _Reflect() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum InterfacePolicy {
        EXCLUDE,
        INCLUDE;


        public boolean isIncludeInterfaces() {
            return this == INCLUDE;
        }
    }

    public static final class predicates {
        public static Predicate<Executable> isPublic() {
            return ex -> Modifier.isPublic(ex.getModifiers());
        }

        public static Predicate<Executable> paramCount(int paramCount) {
            return ex -> ex.getParameterCount() == paramCount;
        }

        public static Predicate<Executable> paramAssignableFrom(int paramIndex, Class<?> paramType) {
            return ex -> ex.getParameterTypes()[paramIndex].isAssignableFrom(paramType);
        }

        public static Predicate<Executable> paramAssignableFromValue(int paramIndex, @Nullable Object value) {
            if (value == null) {
                return _Predicates.alwaysTrue();
            }
            return ex -> ex.getParameterTypes()[paramIndex].isAssignableFrom(value.getClass());
        }

        @Generated
        private predicates() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static enum TypeHierarchyPolicy {
        EXCLUDE,
        INCLUDE;


        public boolean isIncludeTypeHierarchy() {
            return this == INCLUDE;
        }
    }
}

