/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.binding;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.causeway.commons.binding.ChangeListener;
import org.apache.causeway.commons.binding.InvalidationListener;
import org.apache.causeway.commons.binding.Observable;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

abstract class InternalUtil<T> {
    protected final Observable<T> observable;

    static <T> InternalUtil<T> addListener(@Nullable InternalUtil<T> helper, @NonNull Observable<T> observable, @NonNull InvalidationListener listener) {
        observable.getValue();
        return helper == null ? new SingleInvalidation<T>(observable, listener) : helper.addListener(listener);
    }

    static <T> InternalUtil<T> removeListener(@Nullable InternalUtil<T> helper, @NonNull InvalidationListener listener) {
        return helper == null ? null : helper.removeListener(listener);
    }

    static <T> InternalUtil<T> addListener(@Nullable InternalUtil<T> helper, @NonNull Observable<T> observable, @NonNull ChangeListener<? super T> listener) {
        return helper == null ? new SingleChange<T>(observable, listener) : helper.addListener(listener);
    }

    static <T> InternalUtil<T> removeListener(@Nullable InternalUtil<T> helper, @NonNull ChangeListener<? super T> listener) {
        return helper == null ? null : helper.removeListener(listener);
    }

    static <T> void fireValueChanged(InternalUtil<T> helper) {
        if (helper != null) {
            helper.fireValueChanged();
        }
    }

    private InternalUtil(Observable<T> observable) {
        this.observable = observable;
    }

    protected abstract InternalUtil<T> addListener(InvalidationListener var1);

    protected abstract InternalUtil<T> removeListener(InvalidationListener var1);

    protected abstract InternalUtil<T> addListener(ChangeListener<? super T> var1);

    protected abstract InternalUtil<T> removeListener(ChangeListener<? super T> var1);

    protected abstract void fireValueChanged();

    private static int trimListeners(int size, Object[] listeners) {
        int index;
        Predicate<Object> p = t -> t instanceof WeakListener && ((WeakListener)t).isNoLongerReferenced();
        for (index = 0; index < size && !p.test(listeners[index]); ++index) {
        }
        if (index < size) {
            for (int src = index + 1; src < size; ++src) {
                if (p.test(listeners[src])) continue;
                listeners[index++] = listeners[src];
            }
            int oldSize = size;
            size = index;
            while (index < oldSize) {
                listeners[index] = null;
                ++index;
            }
        }
        return size;
    }

    private static class SingleInvalidation<T>
    extends InternalUtil<T> {
        private final InvalidationListener listener;

        private SingleInvalidation(Observable<T> observable, InvalidationListener listener) {
            super(observable);
            this.listener = listener;
        }

        @Override
        protected InternalUtil<T> addListener(InvalidationListener listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected InternalUtil<T> removeListener(InvalidationListener listener) {
            return listener.equals(this.listener) ? null : this;
        }

        @Override
        protected InternalUtil<T> addListener(ChangeListener<? super T> listener) {
            return new Generic<T>(this.observable, this.listener, listener);
        }

        @Override
        protected InternalUtil<T> removeListener(ChangeListener<? super T> listener) {
            return this;
        }

        @Override
        protected void fireValueChanged() {
            try {
                this.listener.invalidated(this.observable);
            }
            catch (Exception e) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            }
        }
    }

    private static class SingleChange<T>
    extends InternalUtil<T> {
        private final ChangeListener<? super T> listener;
        private T currentValue;

        private SingleChange(Observable<T> observable, ChangeListener<? super T> listener) {
            super(observable);
            this.listener = listener;
            this.currentValue = observable.getValue();
        }

        @Override
        protected InternalUtil<T> addListener(InvalidationListener listener) {
            return new Generic<T>(this.observable, listener, this.listener);
        }

        @Override
        protected InternalUtil<T> removeListener(InvalidationListener listener) {
            return this;
        }

        @Override
        protected InternalUtil<T> addListener(ChangeListener<? super T> listener) {
            return new Generic<T>(this.observable, this.listener, listener);
        }

        @Override
        protected InternalUtil<T> removeListener(ChangeListener<? super T> listener) {
            return listener.equals(this.listener) ? null : this;
        }

        @Override
        protected void fireValueChanged() {
            boolean changed;
            T oldValue = this.currentValue;
            this.currentValue = this.observable.getValue();
            boolean bl = this.currentValue == null ? oldValue != null : (changed = !this.currentValue.equals(oldValue));
            if (changed) {
                try {
                    this.listener.changed(this.observable, oldValue, this.currentValue);
                }
                catch (Exception e) {
                    Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                }
            }
        }
    }

    static interface WeakListener {
        public boolean isNoLongerReferenced();
    }

    private static class Generic<T>
    extends InternalUtil<T> {
        private InvalidationListener[] invalidationListeners;
        private ChangeListener<? super T>[] changeListeners;
        private int invalidationSize;
        private int changeSize;
        private boolean locked;
        private T currentValue;

        private Generic(Observable<T> observable, InvalidationListener listener0, InvalidationListener listener1) {
            super(observable);
            this.invalidationListeners = new InvalidationListener[]{listener0, listener1};
            this.invalidationSize = 2;
        }

        private Generic(Observable<T> observable, ChangeListener<? super T> listener0, ChangeListener<? super T> listener1) {
            super(observable);
            this.changeListeners = new ChangeListener[]{listener0, listener1};
            this.changeSize = 2;
            this.currentValue = observable.getValue();
        }

        private Generic(Observable<T> observable, InvalidationListener invalidationListener, ChangeListener<? super T> changeListener) {
            super(observable);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener};
            this.invalidationSize = 1;
            this.changeListeners = new ChangeListener[]{changeListener};
            this.changeSize = 1;
            this.currentValue = observable.getValue();
        }

        @Override
        protected Generic<T> addListener(InvalidationListener listener) {
            if (this.invalidationListeners == null) {
                this.invalidationListeners = new InvalidationListener[]{listener};
                this.invalidationSize = 1;
            } else {
                int oldCapacity = this.invalidationListeners.length;
                if (this.locked) {
                    int newCapacity = this.invalidationSize < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                    this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, newCapacity);
                } else if (this.invalidationSize == oldCapacity) {
                    this.invalidationSize = InternalUtil.trimListeners(this.invalidationSize, this.invalidationListeners);
                    if (this.invalidationSize == oldCapacity) {
                        int newCapacity = oldCapacity * 3 / 2 + 1;
                        this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, newCapacity);
                    }
                }
                this.invalidationListeners[this.invalidationSize++] = listener;
            }
            return this;
        }

        @Override
        protected InternalUtil<T> removeListener(InvalidationListener listener) {
            if (this.invalidationListeners != null) {
                for (int index = 0; index < this.invalidationSize; ++index) {
                    if (!listener.equals(this.invalidationListeners[index])) continue;
                    if (this.invalidationSize == 1) {
                        if (this.changeSize == 1) {
                            return new SingleChange<T>(this.observable, this.changeListeners[0]);
                        }
                        this.invalidationListeners = null;
                        this.invalidationSize = 0;
                        break;
                    }
                    if (this.invalidationSize == 2 && this.changeSize == 0) {
                        return new SingleInvalidation(this.observable, this.invalidationListeners[1 - index]);
                    }
                    int numMoved = this.invalidationSize - index - 1;
                    InvalidationListener[] oldListeners = this.invalidationListeners;
                    if (this.locked) {
                        this.invalidationListeners = new InvalidationListener[this.invalidationListeners.length];
                        System.arraycopy(oldListeners, 0, this.invalidationListeners, 0, index);
                    }
                    if (numMoved > 0) {
                        System.arraycopy(oldListeners, index + 1, this.invalidationListeners, index, numMoved);
                    }
                    --this.invalidationSize;
                    if (this.locked) break;
                    this.invalidationListeners[this.invalidationSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected InternalUtil<T> addListener(ChangeListener<? super T> listener) {
            if (this.changeListeners == null) {
                this.changeListeners = new ChangeListener[]{listener};
                this.changeSize = 1;
            } else {
                int oldCapacity = this.changeListeners.length;
                if (this.locked) {
                    int newCapacity = this.changeSize < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                    this.changeListeners = Arrays.copyOf(this.changeListeners, newCapacity);
                } else if (this.changeSize == oldCapacity) {
                    this.changeSize = InternalUtil.trimListeners(this.changeSize, this.changeListeners);
                    if (this.changeSize == oldCapacity) {
                        int newCapacity = oldCapacity * 3 / 2 + 1;
                        this.changeListeners = Arrays.copyOf(this.changeListeners, newCapacity);
                    }
                }
                this.changeListeners[this.changeSize++] = listener;
            }
            if (this.changeSize == 1) {
                this.currentValue = this.observable.getValue();
            }
            return this;
        }

        @Override
        protected InternalUtil<T> removeListener(ChangeListener<? super T> listener) {
            if (this.changeListeners != null) {
                for (int index = 0; index < this.changeSize; ++index) {
                    if (!listener.equals(this.changeListeners[index])) continue;
                    if (this.changeSize == 1) {
                        if (this.invalidationSize == 1) {
                            return new SingleInvalidation(this.observable, this.invalidationListeners[0]);
                        }
                        this.changeListeners = null;
                        this.changeSize = 0;
                        break;
                    }
                    if (this.changeSize == 2 && this.invalidationSize == 0) {
                        return new SingleChange<T>(this.observable, this.changeListeners[1 - index]);
                    }
                    int numMoved = this.changeSize - index - 1;
                    ChangeListener<? super T>[] oldListeners = this.changeListeners;
                    if (this.locked) {
                        this.changeListeners = new ChangeListener[this.changeListeners.length];
                        System.arraycopy(oldListeners, 0, this.changeListeners, 0, index);
                    }
                    if (numMoved > 0) {
                        System.arraycopy(oldListeners, index + 1, this.changeListeners, index, numMoved);
                    }
                    --this.changeSize;
                    if (this.locked) break;
                    this.changeListeners[this.changeSize] = null;
                    break;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void fireValueChanged() {
            InvalidationListener[] curInvalidationList = this.invalidationListeners;
            int curInvalidationSize = this.invalidationSize;
            ChangeListener<? super T>[] curChangeList = this.changeListeners;
            int curChangeSize = this.changeSize;
            try {
                this.locked = true;
                for (int i = 0; i < curInvalidationSize; ++i) {
                    try {
                        curInvalidationList[i].invalidated(this.observable);
                        continue;
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
                if (curChangeSize > 0) {
                    boolean changed;
                    T oldValue = this.currentValue;
                    this.currentValue = this.observable.getValue();
                    boolean bl = this.currentValue == null ? oldValue != null : (changed = !this.currentValue.equals(oldValue));
                    if (changed) {
                        for (int i = 0; i < curChangeSize; ++i) {
                            try {
                                curChangeList[i].changed(this.observable, oldValue, this.currentValue);
                                continue;
                            }
                            catch (Exception e) {
                                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                            }
                        }
                    }
                }
            }
            finally {
                this.locked = false;
            }
        }
    }

    static final class WeakInvalidationListener
    implements InvalidationListener,
    WeakListener {
        private final WeakReference<InvalidationListener> ref;

        public WeakInvalidationListener(@NonNull InvalidationListener listener) {
            this.ref = new WeakReference<InvalidationListener>(listener);
        }

        @Override
        public boolean isNoLongerReferenced() {
            return this.ref.get() == null;
        }

        @Override
        public void invalidated(Observable<?> observable) {
            InvalidationListener listener = (InvalidationListener)this.ref.get();
            if (listener != null) {
                listener.invalidated(observable);
            } else {
                observable.removeListener(this);
            }
        }
    }

    static final class WeakChangeListener<T>
    implements ChangeListener<T>,
    WeakListener {
        private final WeakReference<ChangeListener<T>> ref;

        public WeakChangeListener(@NonNull ChangeListener<T> listener) {
            this.ref = new WeakReference<ChangeListener<ChangeListener<T>>>(listener);
        }

        @Override
        public boolean isNoLongerReferenced() {
            return this.ref.get() == null;
        }

        @Override
        public void changed(Observable<? extends T> observable, T oldValue, T newValue) {
            ChangeListener listener = (ChangeListener)this.ref.get();
            if (listener != null) {
                listener.changed(observable, oldValue, newValue);
            } else {
                observable.removeListener(this);
            }
        }
    }
}

