/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug.xray;

import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.debug.xray.XrayDataModel;
import org.apache.causeway.commons.internal.debug.xray.XrayModel;
import org.jspecify.annotations.NonNull;

record XrayModelSimple(MutableTreeNode rootNode, Map<String, MutableTreeNode> nodesById, Map<String, Stack<MutableTreeNode>> nodeStacksById) implements XrayModel
{
    XrayModelSimple(MutableTreeNode rootNode) {
        this(rootNode, _Maps.newConcurrentHashMap(), _Maps.newConcurrentHashMap());
    }

    @Override
    public MutableTreeNode addContainerNode(@NonNull MutableTreeNode parent, final @NonNull String name, final @NonNull String id, final @NonNull XrayModel.Stickiness stickiness) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
        newNode.setUserObject(new XrayModel.HasIdAndLabel(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getLabel() {
                return name;
            }

            @Override
            public XrayModel.Stickiness getStickiness() {
                return stickiness;
            }
        });
        ((DefaultMutableTreeNode)parent).add(newNode);
        this.nodesById.put(id, newNode);
        return newNode;
    }

    @Override
    public <T extends XrayDataModel> T addDataNode(@NonNull MutableTreeNode parent, @NonNull T dataModel) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
        newNode.setUserObject(dataModel);
        ((DefaultMutableTreeNode)parent).add(newNode);
        this.nodesById.put(dataModel.getId(), newNode);
        return dataModel;
    }

    @Override
    public Optional<MutableTreeNode> lookupNode(String id) {
        return Optional.ofNullable(this.nodesById.get(id));
    }

    @Override
    public void remove(MutableTreeNode node) {
        XrayModel.HasIdAndLabel hasId = (XrayModel.HasIdAndLabel)((DefaultMutableTreeNode)node).getUserObject();
        this.nodesById.remove(hasId.getId());
    }

    @Override
    public Stack<MutableTreeNode> getNodeStack(String id) {
        return this.nodeStacksById.computeIfAbsent(id, __ -> new Stack());
    }
}

