/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.functional;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Either<L, R> {
    public static <L, R> Either<L, R> left(@NonNull L left) {
        return new Left(left);
    }

    public static <L, R> Either<L, R> right(@NonNull R right) {
        return new Right(right);
    }

    public Optional<L> left();

    public Optional<R> right();

    public L leftIfAny();

    public R rightIfAny();

    public boolean isLeft();

    public boolean isRight();

    public <T> Either<T, R> mapLeft(@NonNull Function<L, T> var1);

    public <T> Either<L, T> mapRight(@NonNull Function<R, T> var1);

    public <X, Y> Either<X, Y> map(@NonNull Function<L, X> var1, @NonNull Function<R, Y> var2);

    public <T> T fold(@NonNull BiFunction<L, R, T> var1);

    public <T> T fold(@NonNull Function<L, T> var1, @NonNull Function<R, T> var2);

    public void accept(@NonNull Consumer<L> var1, @NonNull Consumer<R> var2);

    public record Left<L, R>(L _left) implements Either<L, R>,
    Serializable
    {
        @Override
        public Optional<L> left() {
            return Optional.ofNullable(this._left);
        }

        @Override
        public Optional<R> right() {
            return Optional.empty();
        }

        @Override
        public L leftIfAny() {
            return this._left;
        }

        @Override
        public R rightIfAny() {
            return null;
        }

        @Override
        public final boolean isLeft() {
            return true;
        }

        @Override
        public final boolean isRight() {
            return false;
        }

        @Override
        public final <T> Either<T, R> mapLeft(@NonNull Function<L, T> leftMapper) {
            return Either.left(leftMapper.apply(this._left));
        }

        @Override
        public final <T> Either<L, T> mapRight(@NonNull Function<R, T> rightMapper) {
            return Either.left(this._left);
        }

        @Override
        public final <X, Y> Either<X, Y> map(@NonNull Function<L, X> leftMapper, @NonNull Function<R, Y> rightMapper) {
            return Either.left(leftMapper.apply(this._left));
        }

        @Override
        public final <T> T fold(@NonNull BiFunction<L, R, T> biMapper) {
            return biMapper.apply(this._left, null);
        }

        @Override
        public final <T> T fold(@NonNull Function<L, T> leftMapper, @NonNull Function<R, T> rightMapper) {
            return leftMapper.apply(this._left);
        }

        @Override
        public final void accept(@NonNull Consumer<L> leftConsumer, @NonNull Consumer<R> rightConsumer) {
            leftConsumer.accept(this._left);
        }
    }

    public record Right<L, R>(R _right) implements Either<L, R>,
    Serializable
    {
        @Override
        public Optional<L> left() {
            return Optional.empty();
        }

        @Override
        public Optional<R> right() {
            return Optional.ofNullable(this._right);
        }

        @Override
        public L leftIfAny() {
            return null;
        }

        @Override
        public R rightIfAny() {
            return this._right;
        }

        @Override
        public final boolean isLeft() {
            return false;
        }

        @Override
        public final boolean isRight() {
            return true;
        }

        @Override
        public final <T> Either<T, R> mapLeft(@NonNull Function<L, T> leftMapper) {
            return Either.right(this._right);
        }

        @Override
        public final <T> Either<L, T> mapRight(@NonNull Function<R, T> rightMapper) {
            return Either.right(rightMapper.apply(this._right));
        }

        @Override
        public final <X, Y> Either<X, Y> map(@NonNull Function<L, X> leftMapper, @NonNull Function<R, Y> rightMapper) {
            return Either.right(rightMapper.apply(this._right));
        }

        @Override
        public final <T> T fold(@NonNull BiFunction<L, R, T> biMapper) {
            return biMapper.apply(null, this._right);
        }

        @Override
        public final <T> T fold(@NonNull Function<L, T> leftMapper, @NonNull Function<R, T> rightMapper) {
            return rightMapper.apply(this._right);
        }

        @Override
        public final void accept(@NonNull Consumer<L> leftConsumer, @NonNull Consumer<R> rightConsumer) {
            rightConsumer.accept(this._right);
        }
    }
}

