/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.primitives;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public record _Ints() {
    private static final Consumer<String> IGNORE_ERRORS = t -> {};

    public static Range rangeClosed(int a, int b) {
        if (a > b) {
            throw _Exceptions.illegalArgument("bounds must be ordered in [%d, %d]", a, b);
        }
        return Range.of(Bound.inclusive(a), Bound.inclusive(b));
    }

    public static Range rangeOpenEnded(int a, int b) {
        if (a == b) {
            return Range.empty();
        }
        if (a >= b) {
            throw _Exceptions.illegalArgument("bounds must be ordered in [%d, %d]", a, b);
        }
        return Range.of(Bound.inclusive(a), Bound.exclusive(b));
    }

    public static OptionalInt parseInt(String s, int radix, Consumer<String> onFailure) {
        long parseResult = _Ints.parseIntElseLongMaxValue(s, radix, onFailure);
        if (_Ints.isParseSuccess(parseResult)) {
            return OptionalInt.of(Math.toIntExact(parseResult));
        }
        return OptionalInt.empty();
    }

    public static OptionalInt parseInt(String s, int radix) {
        return _Ints.parseInt(s, radix, IGNORE_ERRORS);
    }

    private static boolean isParseSuccess(long value) {
        return value != Long.MAX_VALUE;
    }

    private static long parseIntElseLongMaxValue(@Nullable String s, int radix, @NonNull Consumer<String> onFailure) {
        if (s == null) {
            onFailure.accept("null");
            return Long.MAX_VALUE;
        }
        if (radix < 2) {
            onFailure.accept("radix " + radix + " less than Character.MIN_RADIX");
            return Long.MAX_VALUE;
        }
        if (radix > 36) {
            onFailure.accept("radix " + radix + " greater than Character.MAX_RADIX");
            return Long.MAX_VALUE;
        }
        boolean negative = false;
        int i = 0;
        int len = s.length();
        int limit = -2147483647;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    onFailure.accept(s);
                    return Long.MAX_VALUE;
                }
                if (len == 1) {
                    onFailure.accept(s);
                    return Long.MAX_VALUE;
                }
                ++i;
            }
            int multmin = limit / radix;
            int result = 0;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0 || result < multmin) {
                    onFailure.accept(s);
                    return Long.MAX_VALUE;
                }
                if ((result *= radix) < limit + digit) {
                    onFailure.accept(s);
                    return Long.MAX_VALUE;
                }
                result -= digit;
            }
            int value = negative ? result : -result;
            return value;
        }
        onFailure.accept(s);
        return Long.MAX_VALUE;
    }

    public static int[] flatten(@NonNull int[][] nested) {
        int n = nested.length;
        int stride = nested[0].length;
        int[] flattened = new int[n * stride];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(nested[i], 0, flattened, i * stride, stride);
        }
        return flattened;
    }

    public static int[][] partition(@NonNull int[] flattened, int stride) {
        int n = flattened.length / stride;
        _Assert.assertEquals((Object)flattened.length, (Object)(n * stride), () -> "flattened.length must be divisible by stride");
        int[][] nested = new int[n][stride];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(flattened, i * stride, nested[i], 0, stride);
        }
        return nested;
    }

    public static String rowForm(@NonNull int[] array) {
        return _Ints.rowForm(array, 8, Integer::toString);
    }

    public static String rowForm(@NonNull int[] array, int columnWidth, @NonNull IntFunction<String> cellFormatter) {
        int m = array.length;
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < m; ++j) {
            int cellValue = array[j];
            String cellStringFull = cellFormatter.apply(cellValue);
            String cellStringTrimmed = _Strings.ellipsifyAtEnd(cellStringFull, columnWidth, "..");
            int spacesCount = columnWidth - cellStringTrimmed.length();
            for (int k = 0; k < spacesCount; ++k) {
                sb.append(' ');
            }
            sb.append(cellStringTrimmed);
        }
        sb.append("\n");
        return sb.toString();
    }

    public static String tableForm(@NonNull int[][] nested) {
        return _Ints.tableForm(nested, 8, Integer::toString);
    }

    public static String tableForm(@NonNull int[][] nested, int columnWidth, @NonNull IntFunction<String> cellFormatter) {
        int n = nested.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(_Ints.rowForm(nested[i], columnWidth, cellFormatter));
        }
        return sb.toString();
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public record Bound(int value, boolean isInclusive) {
        public static @NonNull Bound inclusive(int value) {
            return new Bound(value, true);
        }

        public static @NonNull Bound exclusive(int value) {
            return new Bound(value, true);
        }
    }

    public record Range(Bound lowerBound, Bound upperBound, boolean isEmpty) {
        public static Range empty() {
            return new Range(null, null, true);
        }

        public static Range of(@NonNull Bound lowerBound, @NonNull Bound upperBound) {
            return new Range(lowerBound, upperBound, false);
        }

        public boolean contains(int value) {
            boolean isAboveUpper;
            boolean isBelowLower;
            if (this.isEmpty) {
                return false;
            }
            boolean bl = this.lowerBound.isInclusive() ? value < this.lowerBound.value() : (isBelowLower = value <= this.lowerBound.value());
            if (isBelowLower) {
                return false;
            }
            boolean bl2 = this.upperBound.isInclusive() ? value > this.upperBound.value() : (isAboveUpper = value >= this.upperBound.value());
            return !isAboveUpper;
        }

        public int bounded(int value) {
            int nearestToUpper;
            int distanceToUpper;
            if (this.isEmpty) {
                return value;
            }
            if (this.contains(value)) {
                return value;
            }
            int nearestToLower = this.nearestToLower();
            int distanceToLower = value - nearestToLower;
            return distanceToLower <= (distanceToUpper = value - (nearestToUpper = this.nearestToUpper())) ? nearestToLower : nearestToUpper;
        }

        private int nearestToLower() {
            if (this.isEmpty) {
                throw _Exceptions.unsupportedOperation();
            }
            return this.lowerBound.isInclusive() ? this.lowerBound.value() : this.lowerBound.value() + 1;
        }

        private int nearestToUpper() {
            if (this.isEmpty) {
                throw _Exceptions.unsupportedOperation();
            }
            return this.upperBound.isInclusive() ? this.upperBound.value() : this.upperBound.value() - 1;
        }

        public @NonNull Optional<Range> intersect(@NonNull Range other) {
            if (this.isEmpty) {
                return Optional.empty();
            }
            int s1 = this.nearestToLower();
            int e1 = this.nearestToUpper();
            int s2 = other.nearestToLower();
            int e2 = other.nearestToUpper();
            if (s2 > e1 || s1 > e2) {
                return Optional.empty();
            }
            return Optional.of(Range.of(Bound.inclusive(Math.max(s1, s2)), Bound.inclusive(Math.min(e1, e2))));
        }

        @Override
        public String toString() {
            if (this.isEmpty) {
                return "[]";
            }
            return String.format("%s%d,%d%S", Character.valueOf(this.lowerBound.isInclusive() ? (char)'[' : '('), this.lowerBound.value(), this.upperBound.value(), Character.valueOf(this.upperBound.isInclusive() ? (char)']' : ')'));
        }

        public IntStream stream() {
            if (this.isEmpty) {
                return IntStream.empty();
            }
            return IntStream.rangeClosed(this.nearestToLower(), this.nearestToUpper());
        }

        public PrimitiveIterator.OfInt iterator() {
            if (this.isEmpty) {
                return IntStream.empty().iterator();
            }
            return new PrimitiveIterator.OfInt(){
                int next;
                final int upperIncluded;
                {
                    this.next = this.nearestToLower();
                    this.upperIncluded = this.nearestToUpper();
                }

                @Override
                public int nextInt() {
                    if (!this.hasNext()) {
                        throw _Exceptions.noSuchElement();
                    }
                    int result = this.next++;
                    return result;
                }

                @Override
                public boolean hasNext() {
                    return this.next <= this.upperIncluded;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface BiIntFunction<R> {
        public R apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface BiIntConsumer {
        public void accept(int var1, int var2);
    }
}

