/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import jakarta.inject.Named;
import java.util.Locale;
import lombok.Generated;
import org.apache.causeway.commons.internal.base._Strings;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;

final class _ClassCacheUtil {
    static @Nullable String inferName(Class<?> type, MergedAnnotations mergedAnnotations) {
        String named;
        MergedAnnotation namedAnnot = mergedAnnotations.get(Named.class);
        String string = named = namedAnnot.isPresent() ? mergedAnnotations.get(Named.class).getString("value") : null;
        if (!_Strings.isEmpty(named)) {
            return named;
        }
        block7: for (MergedAnnotation annot : mergedAnnotations) {
            switch (annot.getType().getName()) {
                case "jakarta.persistence.Table": 
                case "javax.jdo.annotations.PersistenceCapable": {
                    String schema = annot.getString("schema");
                    if (_Strings.isEmpty(schema)) continue block7;
                    String table = annot.getString("table");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = schema.toLowerCase(Locale.ROOT);
                    objectArray[1] = _Strings.nonEmpty(table).orElseGet(type::getSimpleName);
                    return "%s.%s".formatted(objectArray);
                }
            }
        }
        return null;
    }

    static boolean isJdoPersistenceCapable(MergedAnnotations mergedAnnotations) {
        for (MergedAnnotation annot : mergedAnnotations) {
            switch (annot.getType().getName()) {
                case "javax.jdo.annotations.PersistenceCapable": {
                    return true;
                }
            }
        }
        return false;
    }

    static boolean isJdoEmbeddedOnly(MergedAnnotations mergedAnnotations) {
        for (MergedAnnotation annot : mergedAnnotations) {
            switch (annot.getType().getName()) {
                case "javax.jdo.annotations.PersistenceCapable": {
                    if (!"true".equals(annot.getString("embeddedOnly"))) break;
                    return true;
                }
                case "javax.jdo.annotations.EmbeddedOnly": {
                    return true;
                }
            }
        }
        return false;
    }

    private static @Nullable String nameFromPersistenceTable(Class<?> type, @Nullable String schema, @Nullable String table) {
        if (_Strings.isEmpty(schema)) {
            return null;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = schema;
        objectArray[1] = _Strings.nonEmpty(table).orElseGet(type::getSimpleName);
        return "%s.%s".formatted(objectArray);
    }

    @Generated
    private _ClassCacheUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

