/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import org.apache.causeway.commons.functional.ThrowingRunnable;

public record _MemoryUsage(long usedInKibiBytes) {
    static int indent = 0;

    private _MemoryUsage(MemoryUsage usage) {
        this(usage.getUsed() / 1024L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static _MemoryUsage measureMetaspace(ThrowingRunnable runnable) {
        _MemoryUsage before = _MemoryUsage.metaspace();
        _MemoryUsage after = null;
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
        }
        finally {
            after = _MemoryUsage.metaspace();
        }
        return after.minus(before);
    }

    private static _MemoryUsage metaspace() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!pool.getName().contains("Metaspace")) continue;
            return new _MemoryUsage(pool.getUsage());
        }
        throw new RuntimeException("Metaspace Usage not found");
    }

    @Override
    public String toString() {
        return String.format("%,d KiB", this.usedInKibiBytes);
    }

    private _MemoryUsage minus(_MemoryUsage before) {
        return new _MemoryUsage(this.usedInKibiBytes - before.usedInKibiBytes);
    }
}

