/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug.xray;

import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.debug.xray.XrayDataModel;
import org.jspecify.annotations.Nullable;

public interface XrayModel {
    public MutableTreeNode rootNode();

    default public MutableTreeNode getThreadNode(ThreadMemento threadMemento) {
        return this.lookupNode(threadMemento.id()).orElseGet(() -> this.addContainerNode(this.rootNode(), threadMemento.label(), threadMemento.id(), Stickiness.CAN_DELETE_NODE));
    }

    public MutableTreeNode addContainerNode(MutableTreeNode var1, String var2, String var3, Stickiness var4);

    default public MutableTreeNode addContainerNode(MutableTreeNode parent, String name, Stickiness stickiness) {
        return this.addContainerNode(parent, name, UUID.randomUUID().toString(), stickiness);
    }

    public <T extends XrayDataModel> T addDataNode(MutableTreeNode var1, T var2);

    public Optional<MutableTreeNode> lookupNode(String var1);

    public void remove(MutableTreeNode var1);

    default public Optional<XrayDataModel.Sequence> lookupSequence(@Nullable String sequenceId) {
        return _Strings.isNullOrEmpty(sequenceId) ? Optional.empty() : this.lookupNode(sequenceId).map(node -> (XrayDataModel.Sequence)((DefaultMutableTreeNode)node).getUserObject());
    }

    public Stack<MutableTreeNode> getNodeStack(String var1);

    public record ThreadMemento(String id, String label, String multilinelabel) {
        public static ThreadMemento fromCurrentThread() {
            Thread ct = Thread.currentThread();
            return new ThreadMemento(String.format("thread-%d-%s", ct.getId(), ct.getName()), String.format("Thread-%d [%s]", ct.getId(), ct.getName()), String.format("Thread-%d\n%s", ct.getId(), ct.getName()));
        }
    }

    public static enum Stickiness {
        CAN_DELETE_NODE,
        CANNOT_DELETE_NODE;


        boolean isCanDeleteNode() {
            return this == CAN_DELETE_NODE;
        }
    }

    public static abstract class HasIdAndLabel {
        public abstract String getId();

        public abstract String getLabel();

        public abstract Stickiness getStickiness();

        public final String toString() {
            return this.getLabel();
        }
    }
}

