/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.semantics;

import java.beans.Introspector;
import java.lang.reflect.RecordComponent;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.reflection._GenericResolver;
import org.apache.causeway.commons.semantics.CollectionSemantics;
import org.jspecify.annotations.Nullable;

public enum AccessorSemantics {
    GET("get"),
    IS("is"),
    SET("set");

    private final String prefix;

    public static String associationIdentifierFor(_GenericResolver.ResolvedMethod method) {
        return AccessorSemantics.isRecordComponentAccessor(method) ? method.name() : Introspector.decapitalize(_Strings.baseName(method.name()));
    }

    public String prefix(@Nullable String input) {
        return input != null ? this.prefix + input : this.prefix;
    }

    public boolean isPrefixOf(@Nullable String input) {
        return input != null ? input.startsWith(this.prefix) : false;
    }

    public static boolean isPropertyAccessor(_GenericResolver.ResolvedMethod method) {
        return AccessorSemantics.isRecordComponentAccessor(method) || AccessorSemantics.isGetter(method) ? !AccessorSemantics.hasCollectionSemantics(method.returnType()) : false;
    }

    public static boolean isCollectionAccessor(_GenericResolver.ResolvedMethod method) {
        return AccessorSemantics.isRecordComponentAccessor(method) || AccessorSemantics.isNonBooleanGetter(method) ? AccessorSemantics.hasCollectionSemantics(method.returnType()) : false;
    }

    public static boolean isRecordComponentAccessor(_GenericResolver.ResolvedMethod method) {
        Class<?> recordClass = method.implementationClass();
        if (!recordClass.isRecord()) {
            return false;
        }
        for (RecordComponent recordComponent : recordClass.getRecordComponents()) {
            if (!method.name().equals(recordComponent.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCandidateGetterName(@Nullable String name) {
        return GET.isPrefixOf(name) || IS.isPrefixOf(name);
    }

    public static boolean isBooleanGetter(_GenericResolver.ResolvedMethod method) {
        return IS.isPrefixOf(method.name()) && method.isNoArg() && !method.isStatic() && (method.returnType() == Boolean.TYPE || method.returnType() == Boolean.class);
    }

    public static boolean isGetter(_GenericResolver.ResolvedMethod method) {
        return AccessorSemantics.isBooleanGetter(method) || AccessorSemantics.isNonBooleanGetter(method);
    }

    public static boolean isNonBooleanGetter(_GenericResolver.ResolvedMethod method) {
        return AccessorSemantics.isNonBooleanGetter(method, type -> type != Void.TYPE);
    }

    private static boolean isNonBooleanGetter(_GenericResolver.ResolvedMethod method, Predicate<Class<?>> typeFilter) {
        return GET.isPrefixOf(method.name()) && method.isNoArg() && !method.isStatic() && typeFilter.test(method.returnType());
    }

    private static boolean hasCollectionSemantics(Class<?> cls) {
        return CollectionSemantics.valueOf(cls).isPresent();
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    private AccessorSemantics(String prefix) {
        this.prefix = prefix;
    }
}

