/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.metamodel.facets.entity;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.jdo.FetchPlan;
import javax.jdo.JDOHelper;
import javax.jdo.JDOQLTypedQuery;
import javax.jdo.PersistenceManager;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.query.AllInstancesQuery;
import org.apache.causeway.applib.query.NamedQuery;
import org.apache.causeway.applib.query.Query;
import org.apache.causeway.applib.query.QueryRange;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.exceprecog.Category;
import org.apache.causeway.applib.services.exceprecog.ExceptionRecognizerService;
import org.apache.causeway.applib.services.exceprecog.Recognition;
import org.apache.causeway.applib.services.inject.ServiceInjector;
import org.apache.causeway.applib.services.repository.EntityState;
import org.apache.causeway.applib.services.xactn.TransactionService;
import org.apache.causeway.applib.services.xactn.TransactionalProcessor;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.config.beans.PersistenceStack;
import org.apache.causeway.core.metamodel.facetapi.FacetAbstract;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facets.object.entity.EntityFacet;
import org.apache.causeway.core.metamodel.facets.object.entity.EntityOrmMetadata;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.objectmanager.ObjectManager;
import org.apache.causeway.core.metamodel.services.idstringifier.IdStringifierLookupService;
import org.apache.causeway.core.metamodel.services.objectlifecycle.ObjectLifecyclePublisher;
import org.apache.causeway.persistence.jdo.datanucleus.entities.DnEntityStateProvider;
import org.apache.causeway.persistence.jdo.datanucleus.entities.DnOidStoreAndRecoverHelper;
import org.apache.causeway.persistence.jdo.datanucleus.entities.DnStateManagerForCauseway;
import org.apache.causeway.persistence.jdo.datanucleus.metamodel.facets.entity._MetadataUtil;
import org.apache.causeway.persistence.jdo.provider.entities.JdoFacetContext;
import org.apache.causeway.persistence.jdo.spring.integration.TransactionAwarePersistenceManagerFactoryProxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.datanucleus.api.jdo.JDOQuery;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.store.rdbms.RDBMSPropertyNames;
import org.springframework.lang.Nullable;

public class JdoEntityFacet
extends FacetAbstract
implements EntityFacet {
    @Generated
    private static final Logger log = LogManager.getLogger(JdoEntityFacet.class);
    @Inject
    private TransactionAwarePersistenceManagerFactoryProxy pmf;
    @Inject
    private TransactionService txService;
    @Inject
    private ObjectManager objectManager;
    @Inject
    private ExceptionRecognizerService exceptionRecognizerService;
    @Inject
    private JdoFacetContext jdoFacetContext;
    @Inject
    private ObjectLifecyclePublisher objectLifecyclePublisher;
    @Inject
    private IdStringifierLookupService idStringifierLookupService;
    private final Class<?> entityClass;
    private final AtomicReference<Object> primaryKeyTypeForDecoding = new AtomicReference();
    private final AtomicReference<Object> ormMetadata = new AtomicReference();
    private final Map<Class<?>, EntityFacet.PrimaryKeyType<?>> primaryKeyTypesForEncoding = new ConcurrentHashMap();

    public JdoEntityFacet(FacetHolder holder, Class<?> entityClass) {
        super(EntityFacet.class, holder);
        this.entityClass = entityClass;
        _Assert.assertTrue((boolean)JdoEntityFacet.isPersistableType(entityClass), () -> String.format("JdoEntityFacet initialized with type '%s' that is not Persistable (JDO)", entityClass));
        this.getServiceInjector().injectServicesInto((Object)this);
    }

    public PersistenceStack getPersistenceStack() {
        return PersistenceStack.JDO;
    }

    private final EntityFacet.PrimaryKeyType<?> primaryKeyTypeForEncoding(@NonNull Object oid) {
        if (oid == null) {
            throw new NullPointerException("oid is marked non-null but is null");
        }
        Class<?> actualPrimaryKeyClass = oid.getClass();
        EntityFacet.PrimaryKeyType primaryKeyType = this.primaryKeyTypesForEncoding.computeIfAbsent(actualPrimaryKeyClass, key -> this.idStringifierLookupService().primaryKeyTypeFor(this.entityClass, actualPrimaryKeyClass));
        return primaryKeyType;
    }

    public boolean isInjectionPointsResolved(Object pojo) {
        if (pojo instanceof Persistable) {
            DnStateManagerForCauseway.extractFrom((Persistable)pojo).map(DnStateManagerForCauseway::injectServicesIfNotAlready).orElse(false);
        }
        return pojo == null;
    }

    public Optional<String> identifierFor(Object pojo) {
        EntityState entityState = this.getEntityState(pojo);
        if (!entityState.hasOid()) {
            return Optional.empty();
        }
        if (entityState.isHollow()) {
            return DnOidStoreAndRecoverHelper.forEntity((Persistable)pojo).recoverOid();
        }
        PersistenceManager pm = this.getPersistenceManager();
        Object primaryKey = pm.getObjectId(pojo);
        _Assert.assertNotNull((Object)primaryKey, () -> String.format("failed to get OID even though entity is attached %s", pojo.getClass().getName()));
        return this.identifierForDnPrimaryKey(primaryKey);
    }

    public Optional<String> identifierForDnPrimaryKey(@Nullable Object primaryKey) {
        Optional<String> idIfAny = Optional.ofNullable(primaryKey).map(pk -> this.primaryKeyTypeForEncoding(pk).enstringWithCast(pk));
        return idIfAny;
    }

    public Bookmark validateBookmark(@NonNull Bookmark bookmark) {
        if (bookmark == null) {
            throw new NullPointerException("bookmark is marked non-null but is null");
        }
        _Assert.assertNotNull((Object)this.primaryKeyTypeForDecoding().destring(bookmark.getIdentifier()));
        return bookmark;
    }

    public Optional<Object> fetchByBookmark(@NonNull Bookmark bookmark) {
        Object entityPojo;
        if (bookmark == null) {
            throw new NullPointerException("bookmark is marked non-null but is null");
        }
        log.debug("fetchEntity; bookmark={}", (Object)bookmark);
        try {
            PersistenceManager persistenceManager = this.getPersistenceManager();
            Object primaryKey = this.primaryKeyTypeForDecoding().destring(bookmark.getIdentifier());
            FetchPlan fetchPlan = persistenceManager.getFetchPlan();
            fetchPlan.addGroup("default");
            entityPojo = persistenceManager.getObjectById(this.entityClass, primaryKey);
        }
        catch (RuntimeException e) {
            Optional recognition = this.exceptionRecognizerService.recognize((Throwable)e);
            if (recognition.isPresent() && ((Recognition)recognition.get()).getCategory() == Category.NOT_FOUND) {
                return Optional.empty();
            }
            throw e;
        }
        return Optional.ofNullable(entityPojo);
    }

    public Can<ManagedObject> fetchByQuery(Query<?> query) {
        if (log.isDebugEnabled()) {
            log.debug("about to execute Query: {}", (Object)query.getDescription());
        }
        QueryRange range = query.getRange();
        if (query instanceof AllInstancesQuery) {
            AllInstancesQuery queryFindAllInstances = (AllInstancesQuery)query;
            Class queryEntityType = queryFindAllInstances.getResultType();
            _Assert.assertTypeIsInstanceOf((Class)queryEntityType, this.entityClass);
            PersistenceManager persistenceManager = this.getPersistenceManager();
            JDOQLTypedQuery typedQuery = persistenceManager.newJDOQLTypedQuery(queryEntityType);
            typedQuery.extension(RDBMSPropertyNames.PROPERTY_RDBMS_QUERY_MULTIVALUED_FETCH, (Object)"none");
            if (!range.isUnconstrained()) {
                typedQuery.range(range.getStart(), range.getEnd());
            }
            Can<ManagedObject> resultList = this.fetchWithinTransaction(() -> ((JDOQLTypedQuery)typedQuery).executeList());
            if (range.hasLimit()) {
                _Assert.assertTrue(((long)resultList.size() <= range.getLimit() ? 1 : 0) != 0);
            }
            return resultList;
        }
        if (query instanceof NamedQuery) {
            NamedQuery applibNamedQuery = (NamedQuery)query;
            Class queryResultType = applibNamedQuery.getResultType();
            PersistenceManager persistenceManager = this.getPersistenceManager();
            HashMap namedParams = _Maps.newHashMap();
            javax.jdo.Query namedQuery = persistenceManager.newNamedQuery(queryResultType, applibNamedQuery.getName()).setNamedParameters((Map)namedParams);
            namedQuery.extension(RDBMSPropertyNames.PROPERTY_RDBMS_QUERY_MULTIVALUED_FETCH, (Object)"none");
            if (!range.isUnconstrained()) {
                namedQuery.range(range.getStart(), range.getEnd());
            }
            ServiceInjector injector = this.getServiceInjector();
            applibNamedQuery.getParametersByName().values().forEach(arg_0 -> ((ServiceInjector)injector).injectServicesInto(arg_0));
            applibNamedQuery.getParametersByName().forEach(namedParams::put);
            Supplier<List<?>> executeMethod = JdoEntityFacet.hasResultPhrase(namedQuery) ? () -> ((javax.jdo.Query)namedQuery).executeResultList() : () -> ((javax.jdo.Query)namedQuery).executeList();
            Can<ManagedObject> resultList = this.fetchWithinTransaction(executeMethod);
            if (range.hasLimit()) {
                _Assert.assertTrue(((long)resultList.size() <= range.getLimit() ? 1 : 0) != 0);
            }
            return resultList;
        }
        throw _Exceptions.unsupportedOperation((String)"query type %s (%s) not supported by this persistence implementation", (Object[])new Object[]{query.getClass(), query.getDescription()});
    }

    private static boolean hasResultPhrase(javax.jdo.Query<?> namedQuery) {
        if (namedQuery instanceof JDOQuery) {
            JDOQuery jdoQuery = (JDOQuery)namedQuery;
            return jdoQuery.getInternalQuery().getResult() != null;
        }
        return false;
    }

    public void persist(Object pojo) {
        _Assert.assertNullableObjectIsInstanceOf((Object)pojo, this.entityClass);
        if (pojo == null || DnEntityStateProvider.entityState(pojo).isAttached()) {
            return;
        }
        PersistenceManager pm = this.getPersistenceManager();
        log.debug("about to persist entity {}", pojo);
        this.getTransactionalProcessor().runWithinCurrentTransactionElseCreateNew(() -> pm.makePersistent(pojo)).ifFailureFail();
    }

    public void refresh(Object pojo) {
        if (pojo == null) {
            return;
        }
        _Assert.assertNullableObjectIsInstanceOf((Object)pojo, this.entityClass);
        PersistenceManager pm = this.getPersistenceManager();
        log.debug("about to refresh entity {}", pojo);
        this.getTransactionalProcessor().runWithinCurrentTransactionElseCreateNew(() -> pm.refresh(pojo)).ifFailureFail();
    }

    public void delete(Object pojo) {
        if (pojo == null) {
            return;
        }
        _Assert.assertNullableObjectIsInstanceOf((Object)pojo, this.entityClass);
        if (!DnEntityStateProvider.entityState(pojo).hasOid()) {
            throw _Exceptions.illegalArgument((String)"can only delete an entity with an OID", (Object[])new Object[0]);
        }
        PersistenceManager pm = this.getPersistenceManager();
        log.debug("about to delete entity {}", pojo);
        this.getTransactionalProcessor().runWithinCurrentTransactionElseCreateNew(() -> pm.deletePersistent(pojo)).ifFailureFail();
    }

    public EntityState getEntityState(Object pojo) {
        return DnEntityStateProvider.entityState(pojo);
    }

    public Object versionOf(Object pojo) {
        if (this.getEntityState(pojo).isAttached()) {
            return JDOHelper.getVersion((Object)pojo);
        }
        return null;
    }

    public <T> T detach(T pojo) {
        return (T)this.getPersistenceManager().detachCopy(pojo);
    }

    private static boolean isPersistableType(Class<?> type) {
        return Persistable.class.isAssignableFrom(type);
    }

    public boolean isProxyEnhancement(Method method) {
        return this.jdoFacetContext.isMethodProvidedByEnhancement(method);
    }

    private PersistenceManager getPersistenceManager() {
        return this.pmf.getPersistenceManagerFactory().getPersistenceManager();
    }

    private TransactionalProcessor getTransactionalProcessor() {
        return this.txService;
    }

    private Can<ManagedObject> fetchWithinTransaction(Supplier<List<?>> fetcher) {
        return (Can)this.getTransactionalProcessor().callWithinCurrentTransactionElseCreateNew(() -> (Can)_NullSafe.stream((Collection)((Collection)fetcher.get())).map(fetchedObject -> this.adapt(this.objectLifecyclePublisher, fetchedObject)).collect(Can.toCan())).ifFailureFail().getValue().orElseThrow();
    }

    private ManagedObject adapt(ObjectLifecyclePublisher objectLifecyclePublisher, Object fetchedObject) {
        if (fetchedObject instanceof Persistable) {
            ManagedObject entity = this.objectManager.adapt(fetchedObject);
            objectLifecyclePublisher.onPostLoad(entity);
            return entity;
        }
        return this.objectManager.adapt(fetchedObject);
    }

    @Generated
    protected IdStringifierLookupService idStringifierLookupService() {
        return this.idStringifierLookupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    protected EntityFacet.PrimaryKeyType<?> primaryKeyTypeForDecoding() {
        Object $value = this.primaryKeyTypeForDecoding.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.primaryKeyTypeForDecoding;
            synchronized (atomicReference) {
                $value = this.primaryKeyTypeForDecoding.get();
                if ($value == null) {
                    EntityFacet.PrimaryKeyType actualValue = this.idStringifierLookupService().primaryKeyTypeFor(this.entityClass, this.getOrmMetadata().primaryKeyClass());
                    $value = actualValue == null ? this.primaryKeyTypeForDecoding : actualValue;
                    this.primaryKeyTypeForDecoding.set($value);
                }
            }
        }
        return (EntityFacet.PrimaryKeyType)($value == this.primaryKeyTypeForDecoding ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public EntityOrmMetadata getOrmMetadata() {
        Object $value = this.ormMetadata.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.ormMetadata;
            synchronized (atomicReference) {
                $value = this.ormMetadata.get();
                if ($value == null) {
                    EntityOrmMetadata actualValue = _MetadataUtil.ormMetadataFor(this.getPersistenceManager(), this.entityClass);
                    $value = actualValue == null ? this.ormMetadata : actualValue;
                    this.ormMetadata.set($value);
                }
            }
        }
        return (EntityOrmMetadata)($value == this.ormMetadata ? null : $value);
    }
}

