/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.valuetypes;

import java.util.Map;
import javax.annotation.Priority;
import javax.jdo.identity.IntIdentity;
import javax.jdo.identity.SingleFieldIdentity;
import lombok.NonNull;
import org.apache.causeway.applib.util.schema.CommonDtoUtils;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsBasedOnIdStringifier;
import org.apache.causeway.commons.internal.factory._InstanceUtil;
import org.apache.causeway.schema.common.v2.TypedTupleDto;
import org.apache.causeway.schema.common.v2.ValueType;
import org.springframework.stereotype.Component;

@Component
@Priority(value=0x5FFFFFFF)
public class JdoIntIdentityValueSemantics
extends ValueSemanticsBasedOnIdStringifier<IntIdentity> {
    public JdoIntIdentityValueSemantics() {
        super(IntIdentity.class);
    }

    public ValueDecomposition decompose(IntIdentity value) {
        return CommonDtoUtils.typedTupleBuilder((Object)value).addFundamentalType(ValueType.STRING, "targetClassName", SingleFieldIdentity::getTargetClassName).addFundamentalType(ValueType.STRING, "key", arg_0 -> ((JdoIntIdentityValueSemantics)this).enstring(arg_0)).buildAsDecomposition();
    }

    public IntIdentity compose(ValueDecomposition decomposition) {
        Map elementMap = CommonDtoUtils.typedTupleAsMap((TypedTupleDto)((TypedTupleDto)decomposition.rightIfAny()));
        String targetClassName = (String)elementMap.get("targetClassName");
        String key = (String)elementMap.get("key");
        return this.destring(_InstanceUtil.loadClass((String)targetClassName), key);
    }

    public IntIdentity destring(@NonNull Class<?> targetEntityClass, @NonNull String stringified) {
        if (targetEntityClass == null) {
            throw new NullPointerException("targetEntityClass is marked non-null but is null");
        }
        if (stringified == null) {
            throw new NullPointerException("stringified is marked non-null but is null");
        }
        return new IntIdentity(targetEntityClass, stringified);
    }
}

