/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.changetracking;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Objects;
import java.util.Optional;
import org.apache.causeway.applib.annotation.InteractionScope;
import org.apache.causeway.core.metamodel.services.objectlifecycle.PreAndPostValue;
import org.apache.causeway.core.metamodel.services.objectlifecycle.PropertyValuePlaceholder;
import org.apache.causeway.persistence.commons.integration.changetracking.PreAndPostValueEvaluatorService;
import org.apache.causeway.persistence.jdo.datanucleus.entities.DnOidStoreAndRecoverHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.datanucleus.enhancement.Persistable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.persistence.jdo.PreAndPostValueEvaluatorServiceJdo")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="jdo")
@InteractionScope
public class PreAndPostValueEvaluatorServiceJdo
implements PreAndPostValueEvaluatorService {
    private static final Logger log = LogManager.getLogger(PreAndPostValueEvaluatorServiceJdo.class);

    public boolean differ(PreAndPostValue papv) {
        if (papv.getPre() == PropertyValuePlaceholder.NEW && papv.getPost() == PropertyValuePlaceholder.DELETED) {
            return false;
        }
        if (papv.getPre() == PropertyValuePlaceholder.NEW || papv.getPost() == PropertyValuePlaceholder.DELETED) {
            return true;
        }
        if (papv.getPre() instanceof Persistable) {
            Persistable prePersistable = (Persistable)papv.getPre();
            if (!(papv.getPost() instanceof Persistable)) {
                return true;
            }
            Persistable postPersistable = (Persistable)papv.getPost();
            Optional<String> preOidIfAny = DnOidStoreAndRecoverHelper.forEntity(prePersistable).recoverOid();
            Optional<String> postOidIfAny = DnOidStoreAndRecoverHelper.forEntity(postPersistable).recoverOid();
            if (preOidIfAny.isPresent() || postOidIfAny.isPresent()) {
                return !Objects.equals(preOidIfAny, postOidIfAny);
            }
        } else if (papv.getPost() instanceof Persistable) {
            return true;
        }
        return !Objects.equals(papv.getPre(), papv.getPost());
    }

    @Inject
    public PreAndPostValueEvaluatorServiceJdo() {
    }
}

