/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.entities;

import java.util.Optional;
import lombok.NonNull;
import org.apache.causeway.persistence.jdo.datanucleus.entities.DnStateManagerForHollow;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;

public class DnOidStoreAndRecoverHelper {
    @NonNull
    final Persistable entityPojo;

    public static DnOidStoreAndRecoverHelper forEntity(Persistable entityPojo) {
        return new DnOidStoreAndRecoverHelper(entityPojo);
    }

    public void storeOid(String oid) {
        this.entityPojo.dnReplaceStateManager((StateManager)new DnStateManagerForHollow(oid));
        this.entityPojo.dnReplaceFlags();
    }

    public Optional<String> recoverOid() {
        StateManager sm = this.entityPojo.dnGetStateManager();
        if (sm instanceof DnStateManagerForHollow) {
            String oidStringified = ((DnStateManagerForHollow)sm).oidStringified;
            return Optional.of(oidStringified);
        }
        return Optional.empty();
    }

    private DnOidStoreAndRecoverHelper(@NonNull Persistable entityPojo) {
        if (entityPojo == null) {
            throw new NullPointerException("entityPojo is marked non-null but is null");
        }
        this.entityPojo = entityPojo;
    }
}

