/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.valuetypes;

import jakarta.annotation.Priority;
import java.util.Map;
import lombok.NonNull;
import org.apache.causeway.applib.util.schema.CommonDtoUtils;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsBasedOnIdStringifier;
import org.apache.causeway.commons.internal.factory._InstanceUtil;
import org.apache.causeway.schema.common.v2.TypedTupleDto;
import org.apache.causeway.schema.common.v2.ValueType;
import org.datanucleus.identity.DatastoreIdImpl;
import org.springframework.stereotype.Component;

@Component
@Priority(value=0x5FFFFFFF)
public class DnDatastoreIdImplValueSemantics
extends ValueSemanticsBasedOnIdStringifier<DatastoreIdImpl> {
    public static final String STRING_DELIMITER = "[OID]";

    public DnDatastoreIdImplValueSemantics() {
        super(DatastoreIdImpl.class);
    }

    public ValueDecomposition decompose(DatastoreIdImpl value) {
        return CommonDtoUtils.typedTupleBuilder((Object)value).addFundamentalType(ValueType.STRING, "targetClassName", DatastoreIdImpl::getTargetClassName).addFundamentalType(ValueType.STRING, "key", this::enstring).buildAsDecomposition();
    }

    public DatastoreIdImpl compose(ValueDecomposition decomposition) {
        Map elementMap = CommonDtoUtils.typedTupleAsMap((TypedTupleDto)((TypedTupleDto)decomposition.rightIfAny()));
        String targetClassName = (String)elementMap.get("targetClassName");
        String key = (String)elementMap.get("key");
        return this.destring(_InstanceUtil.loadClass((String)targetClassName), key);
    }

    public String enstring(@NonNull DatastoreIdImpl value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return value.getKeyAsObject().toString();
    }

    public DatastoreIdImpl destring(@NonNull Class<?> targetEntityClass, @NonNull String stringified) {
        if (targetEntityClass == null) {
            throw new NullPointerException("targetEntityClass is marked non-null but is null");
        }
        if (stringified == null) {
            throw new NullPointerException("stringified is marked non-null but is null");
        }
        DatastoreIdImpl proto = new DatastoreIdImpl(targetEntityClass.getName(), (Object)stringified);
        String str = proto.toString();
        return new DatastoreIdImpl(str);
    }
}

