/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.metamodel.facets.entity;

import java.util.Optional;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.IdentityType;
import javax.jdo.metadata.MemberMetadata;
import javax.jdo.metadata.TypeMetadata;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.config.beans.CausewayBeanMetaData;
import org.apache.causeway.core.metamodel.facets.object.entity.EntityOrmMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.identity.SCOID;
import org.jspecify.annotations.NonNull;

final class _MetadataUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(_MetadataUtil.class);

    static EntityOrmMetadata ormMetadataFor(@NonNull PersistenceManager persistenceManager, @NonNull Class<?> entityClass) {
        JDOPersistenceManagerFactory pmf = (JDOPersistenceManagerFactory)persistenceManager.getPersistenceManagerFactory();
        TypeMetadata typeMetadata = pmf.getMetadata(entityClass.getName());
        return new EntityOrmMetadata(CausewayBeanMetaData.PersistenceStack.JDO, Optional.ofNullable(typeMetadata.getTable()), Optional.ofNullable(typeMetadata.getSchema()), _MetadataUtil.primaryKeyTypeFor(pmf, typeMetadata, entityClass), _MetadataUtil.columns(typeMetadata), (Object)typeMetadata);
    }

    private static Can<EntityOrmMetadata.ColumnOrmMetadata> columns(TypeMetadata typeMetadata) {
        return (Can)_NullSafe.stream((Object[])typeMetadata.getMembers()).map(_MetadataUtil::column).collect(Can.toCan());
    }

    private static EntityOrmMetadata.ColumnOrmMetadata column(MemberMetadata c) {
        return Optional.ofNullable(c.getColumn()).map(colName -> new EntityOrmMetadata.ColumnOrmMetadata(colName, c.getName(), _MetadataUtil.fieldType(c), (Object)c)).orElse(null);
    }

    private static String fieldType(MemberMetadata c) {
        return Optional.ofNullable(c.getFieldType()).orElseGet(() -> {
            log.warn("failed to get java field type from JDO MemberMetadata in {}", (Object)c.getParent());
            return Object.class.getName();
        });
    }

    private static Class<?> primaryKeyTypeFor(@NonNull JDOPersistenceManagerFactory pmf, @NonNull TypeMetadata typeMetadata, @NonNull Class<?> entityClass) {
        IdentityType identityType = typeMetadata.getIdentityType();
        switch (identityType) {
            case APPLICATION: {
                ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
                PersistenceNucleusContext nucleusContext = pmf.getNucleusContext();
                ClassLoaderResolver clr = nucleusContext.getClassLoaderResolver(contextLoader);
                String objectIdClass = typeMetadata.getObjectIdClass();
                return clr.classForName(objectIdClass);
            }
            case DATASTORE: {
                PersistenceNucleusContext nucleusContext = pmf.getNucleusContext();
                return nucleusContext.getIdentityManager().getDatastoreIdClass();
            }
            case NONDURABLE: {
                return SCOID.class;
            }
        }
        throw new IllegalStateException(String.format("JdoEntityFacet was installed on '%s', yet this entity has IdentityType '%s', which is not supported by the framework's JDO implementation.", entityClass.getName(), identityType));
    }

    @Generated
    private _MetadataUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

