/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.menu;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import javax.jdo.PersistenceManagerFactory;
import lombok.Generated;
import org.apache.causeway.applib.CausewayModuleApplib;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.RestrictTo;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.applib.value.NamedWithMimeType;
import org.apache.causeway.commons.io.ZipUtils;
import org.apache.causeway.persistence.jdo.applib.services.JdoSupportService;
import org.apache.causeway.persistence.jdo.provider.entities.JdoFacetContext;

@Named(value="causeway.persistence.jdo.JdoMetamodelMenu")
@DomainService
@DomainServiceLayout(menuBar=DomainServiceLayout.MenuBar.SECONDARY, named="Prototyping")
@Priority(value=0x1FFFFFFF)
public class JdoMetamodelMenu {
    final JdoSupportService jdoSupport;
    final JdoFacetContext jdoFacetContext;

    private byte[] zip() {
        PersistenceManagerFactory pmFactory = this.getPersistenceManagerFactory();
        ZipUtils.EntryBuilder zipBuilder = ZipUtils.zipEntryBuilder();
        pmFactory.getManagedClasses().stream().filter(arg_0 -> ((JdoFacetContext)this.jdoFacetContext).isPersistenceEnhanced(arg_0)).map(Class::getName).forEach(entityClassName -> zipBuilder.addAsUtf8(this.zipEntryNameFor((String)entityClassName), pmFactory.getMetadata(entityClassName).toString()));
        return zipBuilder.toBytes();
    }

    private String zipEntryNameFor(String className) {
        return className.replace(".", File.separator) + ".xml";
    }

    private PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.jdoSupport.getPersistenceManager().getPersistenceManagerFactory();
    }

    @Inject
    @Generated
    public JdoMetamodelMenu(JdoSupportService jdoSupport, JdoFacetContext jdoFacetContext) {
        this.jdoSupport = jdoSupport;
        this.jdoFacetContext = jdoFacetContext;
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=ActionDomainEvent.class, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING, semantics=SemanticsOf.NON_IDEMPOTENT)
    @ActionLayout(cssClassFa="fa-download", named="Download JDO Metamodels (ZIP)", sequence="500.670.1")
    public class downloadMetamodels {
        @MemberSupport
        public Blob act() {
            byte[] zipBytes = JdoMetamodelMenu.this.zip();
            return Blob.of((String)"jdo-metamodels", (NamedWithMimeType.CommonMimeType)NamedWithMimeType.CommonMimeType.ZIP, (byte[])zipBytes);
        }

        public class ActionDomainEvent
        extends org.apache.causeway.persistence.jdo.metamodel.menu.JdoMetamodelMenu$ActionDomainEvent<downloadMetamodels> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends CausewayModuleApplib.ActionDomainEvent<T> {
    }
}

