/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.object.persistencecapable;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.jdo.annotations.EmbeddedOnly;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.metamodel.facetapi.FacetAbstract;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;

public class JdoPersistenceCapableFacetFromAnnotation
extends FacetAbstract
implements JdoPersistenceCapableFacet {
    private final String schema;
    private final String table;
    private final IdentityType identityType;

    public static Optional<JdoPersistenceCapableFacet> createUsingJdo(Optional<PersistenceCapable> persistenceCapableIfAny, Optional<EmbeddedOnly> embeddedOnlyIfAny, Class<?> cls, FacetHolder facetHolder) {
        boolean isEmbeddedOnly;
        if (!persistenceCapableIfAny.isPresent()) {
            return Optional.empty();
        }
        PersistenceCapable persistenceCapable = persistenceCapableIfAny.get();
        boolean bl = isEmbeddedOnly = Boolean.valueOf(persistenceCapable.embeddedOnly()) != false || embeddedOnlyIfAny.isPresent();
        if (isEmbeddedOnly) {
            return Optional.empty();
        }
        String schema = _Strings.emptyToNull((String)persistenceCapable.schema());
        String table = _Strings.isNotEmpty((CharSequence)persistenceCapable.table()) ? persistenceCapable.table() : cls.getSimpleName();
        IdentityType identityType = persistenceCapable.identityType();
        return Optional.of(new JdoPersistenceCapableFacetFromAnnotation(schema, table, identityType, facetHolder));
    }

    public static Optional<JdoPersistenceCapableFacet> createUsingJpa(Optional<Entity> entityIfAny, Optional<Table> tableIfAny, Class<?> cls, FacetHolder facetHolder) {
        if (!entityIfAny.isPresent()) {
            return Optional.empty();
        }
        String table = tableIfAny.map(tableAnnot -> tableAnnot.name()).map(_Strings::emptyToNull).orElseGet(cls::getSimpleName);
        String schema = tableIfAny.map(tableAnnot -> tableAnnot.schema()).map(_Strings::emptyToNull).orElseGet(cls::getSimpleName);
        IdentityType identityType = IdentityType.UNSPECIFIED;
        return Optional.of(new JdoPersistenceCapableFacetFromAnnotation(schema, table, identityType, facetHolder));
    }

    private JdoPersistenceCapableFacetFromAnnotation(String schemaName, String tableOrTypeName, IdentityType identityType, FacetHolder holder) {
        super(JdoPersistenceCapableFacet.class, holder);
        this.schema = schemaName;
        this.table = tableOrTypeName;
        this.identityType = identityType;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public void visitAttributes(BiConsumer<String, Object> visitor) {
        super.visitAttributes(visitor);
        visitor.accept("schema", this.schema);
        visitor.accept("table", this.table);
        visitor.accept("identityType", this.identityType);
    }
}

