/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.provider.persistence;

import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;

@FunctionalInterface
public interface HasPersistenceManager {
    public PersistenceManager getPersistenceManager();

    default public <T> Query<T> newJdoNamedQuery(Class<T> cls, String queryName) {
        return this.getPersistenceManager().newNamedQuery(cls, queryName);
    }

    default public <T> Query<T> newJdoQuery(Class<T> cls) {
        return this.getPersistenceManager().newQuery(cls);
    }

    default public <T> Query<T> newJdoQuery(Class<T> cls, String filter) {
        return this.getPersistenceManager().newQuery(cls, filter);
    }

    default public void startTransaction() {
        Transaction transaction = this.getPersistenceManager().currentTransaction();
        if (transaction.isActive()) {
            throw new IllegalStateException("Transaction already active");
        }
        transaction.begin();
    }

    default public void endTransaction() {
        Transaction transaction = this.getPersistenceManager().currentTransaction();
        if (transaction.isActive()) {
            transaction.commit();
        }
    }

    default public void abortTransaction() {
        Transaction transaction = this.getPersistenceManager().currentTransaction();
        if (transaction.isActive()) {
            transaction.rollback();
        }
    }

    default public void flushTransaction() {
        Transaction transaction = this.getPersistenceManager().currentTransaction();
        if (transaction.isActive()) {
            transaction.getPersistenceManager().flush();
        }
    }
}

