/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.fixtures.applib.fixturescripts;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.io.TextUtils;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.ExecutionParameters;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class ExecutionParametersDefault
implements ExecutionParameters {
    private static final Pattern keyEqualsValuePattern = Pattern.compile("([^=]*)=(.*)");
    private final String parameters;
    private final Map<String, String> parameterMap;

    public ExecutionParametersDefault(String parameters) {
        this.parameters = parameters;
        this.parameterMap = ExecutionParametersDefault.asKeyValueMap(parameters);
    }

    static Map<String, String> asKeyValueMap(String parameters) {
        LinkedHashMap keyValues = _Maps.newLinkedHashMap();
        if (parameters != null) {
            try {
                TextUtils.streamLines((String)parameters).forEach(line -> {
                    Matcher matcher = keyEqualsValuePattern.matcher((CharSequence)line);
                    if (matcher.matches()) {
                        keyValues.put(matcher.group(1).trim(), matcher.group(2).trim());
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return keyValues;
    }

    @Override
    public String getParameters() {
        return this.parameters;
    }

    @Override
    public String getParameter(String parameterName) {
        return this.parameterMap.get(parameterName);
    }

    @Override
    public <T> T getParameterAsT(String parameterName, Class<T> cls) {
        return (T)_Casts.uncheckedCast((Object)this.getParameterAsObject(parameterName, cls));
    }

    protected Object getParameterAsObject(String parameterName, Class<?> cls) {
        Object value;
        if (Enum.class.isAssignableFrom(cls)) {
            Class<?> enumClass = cls;
            value = this.getParameterAsEnum(parameterName, (Class)_Casts.uncheckedCast(enumClass));
        } else {
            value = cls == Boolean.class ? this.getParameterAsBoolean(parameterName) : (cls == Byte.class ? this.getParameterAsByte(parameterName) : (cls == Short.class ? this.getParameterAsShort(parameterName) : (cls == Integer.class ? this.getParameterAsInteger(parameterName) : (cls == Long.class ? this.getParameterAsLong(parameterName) : (cls == Float.class ? this.getParameterAsFloat(parameterName) : (cls == Double.class ? this.getParameterAsDouble(parameterName) : (cls == Character.class ? this.getParameterAsCharacter(parameterName) : (cls == BigDecimal.class ? this.getParameterAsBigDecimal(parameterName) : (cls == BigInteger.class ? this.getParameterAsBigInteger(parameterName) : (cls == LocalDate.class ? this.getParameterAsLocalDate(parameterName) : (cls == LocalDateTime.class ? this.getParameterAsLocalDateTime(parameterName) : (cls == String.class ? this.getParameter(parameterName) : null))))))))))));
        }
        return value;
    }

    @Override
    public Boolean getParameterAsBoolean(String parameterName) {
        String value = this.getParameter(parameterName);
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public Byte getParameterAsByte(String parameterName) {
        String value = this.getParameter(parameterName);
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        return Byte.valueOf(value);
    }

    @Override
    public Short getParameterAsShort(String parameterName) {
        String value = this.getParameter(parameterName);
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        return Short.valueOf(value);
    }

    @Override
    public Integer getParameterAsInteger(String parameterName) {
        String value = this.getParameter(parameterName);
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        return Integer.valueOf(value);
    }

    @Override
    public Long getParameterAsLong(String parameterName) {
        String value = this.getParameter(parameterName);
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        return Long.valueOf(value);
    }

    @Override
    public Float getParameterAsFloat(String parameterName) {
        String value = this.getParameter(parameterName);
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        return Float.valueOf(value);
    }

    @Override
    public Double getParameterAsDouble(String parameterName) {
        String value = this.getParameter(parameterName);
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        return Double.valueOf(value);
    }

    @Override
    public Character getParameterAsCharacter(String parameterName) {
        String value = this.getParameter(parameterName);
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    @Override
    public BigInteger getParameterAsBigInteger(String parameterName) {
        String value = this.getParameter(parameterName);
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        return new BigInteger(value);
    }

    @Override
    public BigDecimal getParameterAsBigDecimal(String parameterName) {
        String value = this.getParameter(parameterName);
        if (_Strings.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        return new BigDecimal(value);
    }

    @Override
    public LocalDate getParameterAsLocalDate(String parameterName) {
        String value = this.getParameter(parameterName);
        if (value == null) {
            return null;
        }
        return LocalDate.parse((String)value);
    }

    @Override
    public LocalDateTime getParameterAsLocalDateTime(String parameterName) {
        String value = this.getParameter(parameterName);
        if (value == null) {
            return null;
        }
        return LocalDateTime.parse((String)value);
    }

    @Override
    public <T extends Enum<T>> T getParameterAsEnum(String parameterName, Class<T> enumClass) {
        String value = this.getParameter(parameterName);
        return ExecutionParametersDefault.valueOfElseNull(enumClass, value);
    }

    private static <T extends Enum<T>> T valueOfElseNull(Class<T> enumClass, String value) {
        Enum[] enumConstants;
        if (value == null) {
            return null;
        }
        for (Enum enumConstant : enumConstants = (Enum[])enumClass.getEnumConstants()) {
            if (!enumConstant.name().equals(value)) continue;
            return (T)enumConstant;
        }
        return null;
    }

    @Override
    public Map<String, String> getParameterMap() {
        return Collections.unmodifiableMap(this.parameterMap);
    }

    @Override
    public void setParameterIfNotPresent(String parameterName, String parameterValue) {
        if (parameterName == null) {
            throw new IllegalArgumentException("parameterName required");
        }
        if (parameterValue == null) {
            return;
        }
        if (this.parameterMap.containsKey(parameterName)) {
            return;
        }
        this.parameterMap.put(parameterName, parameterValue);
    }

    @Override
    public void setParameter(String parameterName, Boolean parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, Byte parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, Short parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, Integer parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, Long parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, Float parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, Double parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, Character parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, BigInteger parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, java.util.Date parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, Date parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, LocalDate parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, LocalDateTime parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, DateTime parameterValue) {
        StringBuffer buf = new StringBuffer();
        ISODateTimeFormat.dateTimeParser().printTo(buf, (ReadableInstant)parameterValue);
        this.setParameter(parameterName, parameterValue != null ? buf.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, BigDecimal parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.toString() : null);
    }

    @Override
    public void setParameter(String parameterName, Enum<?> parameterValue) {
        this.setParameter(parameterName, parameterValue != null ? parameterValue.name() : null);
    }

    @Override
    public void setParameter(String parameterName, String parameterValue) {
        if (parameterName == null) {
            throw new IllegalArgumentException("parameterName required");
        }
        if (parameterValue == null) {
            return;
        }
        this.parameterMap.put(parameterName, parameterValue);
    }
}

