/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.unittestsupport.applib.matchers;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class FileMatchers {
    private FileMatchers() {
    }

    public static Matcher<File> existsAndNotEmpty() {
        return new TypeSafeMatcher<File>(){

            public void describeTo(Description arg0) {
                arg0.appendText("exists and is not empty");
            }

            public boolean matchesSafely(File f) {
                return f.exists() && f.length() > 0L;
            }
        };
    }

    public static Matcher<File> equalsFile(File file) throws IOException {
        final String canonicalPath = file.getCanonicalPath();
        return new TypeSafeMatcher<File>(){

            public void describeTo(Description arg0) {
                arg0.appendText("file '" + canonicalPath + "'");
            }

            public boolean matchesSafely(File arg0) {
                try {
                    return arg0.getCanonicalPath().equals(canonicalPath);
                }
                catch (IOException e) {
                    return false;
                }
            }
        };
    }
}

