/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.unittestsupport.applib.matchers;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class StringMatchers {
    private StringMatchers() {
    }

    public static Matcher<String> nonEmptyString() {
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String str) {
                return str != null && str.length() > 0;
            }

            public void describeTo(Description description) {
                description.appendText("a non empty string");
            }
        };
    }

    public static Matcher<String> nonEmptyStringOrNull() {
        return CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.nullValue(String.class), StringMatchers.nonEmptyString()});
    }

    public static Matcher<String> matches(final String regex) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("string matching " + regex);
            }

            public boolean matchesSafely(String str) {
                return str.matches(regex);
            }
        };
    }

    public static Matcher<String> startsWith(final String expected) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText(" starts with '" + expected + "'");
            }

            public boolean matchesSafely(String actual) {
                return actual.startsWith(expected);
            }
        };
    }

    public static Matcher<String> contains(final String expected) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText(" contains '" + expected + "'");
            }

            public boolean matchesSafely(String actual) {
                return actual.contains(expected);
            }
        };
    }
}

