/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.unittestsupport.applib.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.commons.io.TextUtils;
import org.approvaltests.core.Options;
import org.approvaltests.core.Scrubber;
import org.approvaltests.reporters.GenericDiffReporter;

public final class ApprovalUtils {
    public static void registerFileExtensionForTextCompare(String ext) {
        if (GenericDiffReporter.TEXT_FILE_EXTENSIONS.contains(ext)) {
            return;
        }
        ArrayList<String> textFileExtensions = new ArrayList<String>(GenericDiffReporter.TEXT_FILE_EXTENSIONS);
        textFileExtensions.add(ext);
        GenericDiffReporter.TEXT_FILE_EXTENSIONS = Collections.unmodifiableList(textFileExtensions);
    }

    public static Options ignoreLineEndings() {
        return new Options().withScrubber(s -> TextUtils.readLines((String)s).join("\n"));
    }

    public static Scrubber jsonPropertiesSortedWhenParentedBy(Predicate<String> applicableForParentKey) {
        return new JsonPropertiesSortedWhenParentedByKey(applicableForParentKey);
    }

    @Generated
    private ApprovalUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    record JsonPropertiesSortedWhenParentedByKey(Predicate<String> applicableForParentKey) implements Scrubber
    {
        public String scrub(String input) {
            JsonNode rootNode = new ObjectMapper().readTree(input);
            this.traverse(rootNode, "");
            String prettyJson = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
            return prettyJson;
        }

        private void traverse(JsonNode node, String parentKey) {
            switch (node.getNodeType()) {
                case OBJECT: {
                    if (this.applicableForParentKey.test(parentKey)) {
                        ObjectNode objectNode = (ObjectNode)node;
                        List<Map.Entry> sortedPropertyEntries = node.properties().stream().sorted((a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).collect(Collectors.toList());
                        objectNode.removeAll();
                        sortedPropertyEntries.forEach(entry -> objectNode.set((String)entry.getKey(), (JsonNode)entry.getValue()));
                    }
                    node.properties().forEach(entry -> this.traverse((JsonNode)entry.getValue(), (String)entry.getKey()));
                    break;
                }
                case ARRAY: {
                    for (JsonNode element : node) {
                        this.traverse(element, parentKey);
                    }
                    break;
                }
            }
        }
    }
}

