/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.components;

import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.commons.internal.base._Strings;
import org.springframework.lang.Nullable;

public enum UiComponentType {
    ABOUT,
    WELCOME,
    SERVICE_ACTIONS,
    ENTITY,
    ENTITY_ICON_AND_TITLE,
    ENTITY_ICON_TITLE_AND_COPYLINK,
    ENTITY_SUMMARY,
    ENTITY_COLLECTION,
    VALUE,
    SCALAR_NAME_AND_VALUE,
    PARAMETERS,
    PROPERTY_EDIT_FORM,
    ACTION_INFO,
    ACTION_PROMPT,
    PROPERTY_EDIT_PROMPT,
    STANDALONE_COLLECTION,
    COLLECTION_CONTENTS,
    COLLECTION_CONTENTS_EXPORT(Optionality.OPTIONAL),
    ENTITY_LINK,
    EMPTY_COLLECTION,
    VOID_RETURN,
    BOOKMARKED_PAGES,
    UNKNOWN,
    HEADER,
    FOOTER;

    private final Optionality optionality;

    private UiComponentType() {
        this.optionality = Optionality.MANDATORY;
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return (String)_Strings.asCamelCase.apply((Object)_Strings.lower((String)this.name()));
    }

    @Nullable
    public static UiComponentType lookup(String id) {
        for (UiComponentType uiComponentType : UiComponentType.values()) {
            if (!uiComponentType.getId().equals(id)) continue;
            return uiComponentType;
        }
        return null;
    }

    private UiComponentType(Optionality optionality) {
        this.optionality = optionality;
    }

    public Optionality getOptionality() {
        return this.optionality;
    }
}

