/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.scalar;

import java.util.Optional;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.interactions.managed.ActionInteractionHead;
import org.apache.causeway.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.causeway.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.scalar.UiScalar;

public interface UiParameter
extends UiScalar {
    public ObjectActionParameter getMetaModel();

    @NonNull
    public ManagedObject getValue();

    public void setValue(ManagedObject var1);

    public ParameterNegotiationModel getParameterNegotiationModel();

    @Override
    default public boolean whetherHidden() {
        return this.getParameterNegotiationModel().getVisibilityConsent(this.getParameterIndex()).isVetoed();
    }

    @Override
    default public Optional<InteractionVeto> disabledReason() {
        Consent usabilityConsent = this.getParameterNegotiationModel().getUsabilityConsent(this.getParameterIndex());
        return usabilityConsent.isAllowed() ? Optional.empty() : Optional.of(InteractionVeto.readonly((Consent)usabilityConsent));
    }

    @Override
    default public int getAutoCompleteMinLength() {
        return this.hasAutoComplete() ? this.getMetaModel().getAutoCompleteMinLength() : 0;
    }

    @Override
    default public boolean hasChoices() {
        return this.getMetaModel().hasChoices();
    }

    @Override
    default public boolean hasAutoComplete() {
        return this.getMetaModel().hasAutoComplete();
    }

    @Override
    default public ManagedObject getDefault() {
        return this.getMetaModel().getDefault(this.getParameterNegotiationModel());
    }

    @Override
    default public Can<ManagedObject> getChoices() {
        return this.getMetaModel().getChoices(this.getParameterNegotiationModel(), InteractionInitiatedBy.USER);
    }

    @Override
    default public Can<ManagedObject> getAutoComplete(String searchArg) {
        return this.getMetaModel().getAutoComplete(this.getParameterNegotiationModel(), searchArg, InteractionInitiatedBy.USER);
    }

    @Override
    default public String getFriendlyName() {
        return this.getMetaModel().getFriendlyName(this::getOwner);
    }

    @Override
    default public Optional<String> getDescribedAs() {
        return this.getMetaModel().getDescription(this::getOwner);
    }

    @Override
    default public String getFileAccept() {
        return Facets.fileAccept((ObjectFeature)this.getMetaModel()).orElse(null);
    }

    @Override
    default public boolean isRequired() {
        return !this.getMetaModel().isOptional();
    }

    @Override
    default public ObjectSpecification getElementType() {
        return this.getMetaModel().getElementType();
    }

    @Override
    default public boolean hasObjectAutoComplete() {
        return Facets.autoCompleteIsPresent((ObjectSpecification)this.getElementType());
    }

    default public int getParameterIndex() {
        return this.getMetaModel().getParameterIndex();
    }

    @Override
    default public String getCssClass() {
        return this.getMetaModel().getCssClass("causeway-");
    }

    @Override
    default public String getIdentifier() {
        return "" + this.getParameterIndex();
    }

    default public ActionInteractionHead getPendingParamHead() {
        return this.getMetaModel().getAction().interactionHead(this.getOwner());
    }
}

