/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.components;

import java.util.Optional;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.causeway.applib.annotation.LabelPosition;
import org.apache.causeway.commons.handler.ChainOfResponsibility;
import org.apache.causeway.core.metamodel.facetapi.Facet;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedFeature;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedParameter;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedValue;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.decorators.DisablingDecorator;
import org.springframework.lang.Nullable;

public interface UiComponentFactory<B, C> {
    public B buttonFor(ButtonRequest var1);

    public C componentFor(ComponentRequest var1);

    public C parameterFor(ComponentRequest var1);

    public LabelAndPosition<C> labelFor(ComponentRequest var1);

    public static interface Handler<T>
    extends ChainOfResponsibility.Handler<ComponentRequest, T> {
    }

    public static final class ComponentRequest {
        @NonNull
        private final ManagedValue managedValue;
        @NonNull
        private final ManagedFeature managedFeature;
        @NonNull
        private final Optional<DisablingDecorator.DisablingDecorationModel> disablingUiModelIfAny;

        public static ComponentRequest of(ManagedParameter managedParameter) {
            return ComponentRequest.of((ManagedValue)managedParameter, (ManagedFeature)managedParameter, Optional.empty());
        }

        public String getFriendlyName() {
            return this.managedFeature.getFriendlyName();
        }

        public ObjectSpecification getFeatureTypeSpec() {
            return this.managedFeature.getElementType();
        }

        public Class<?> getFeatureType() {
            return this.managedFeature.getElementClass();
        }

        public boolean isFeatureTypeEqualTo(@Nullable Class<?> type) {
            return this.getFeatureType() == type;
        }

        public boolean isFeatureTypeAssignableFrom(@Nullable Class<?> type) {
            return type != null ? this.getFeatureType().isAssignableFrom(type) : false;
        }

        public boolean isFeatureTypeInstanceOf(@Nullable Class<?> type) {
            return type != null ? type.isAssignableFrom(this.getFeatureType()) : false;
        }

        public <T extends Facet> boolean hasFeatureTypeFacet(@Nullable Class<T> facetType) {
            return facetType != null ? this.getFeatureTypeSpec().containsFacet(facetType) : false;
        }

        public boolean hasFacetForValueType(@Nullable Class<?> valueType) {
            return valueType != null ? Facets.valueTypeMatches(valueType::equals).test(this.getFeatureTypeSpec()) : false;
        }

        public boolean isReadOnly() {
            return ((ManagedProperty)this.managedFeature).checkUsability().isPresent();
        }

        private ComponentRequest(@NonNull ManagedValue managedValue, @NonNull ManagedFeature managedFeature, @NonNull Optional<DisablingDecorator.DisablingDecorationModel> disablingUiModelIfAny) {
            if (managedValue == null) {
                throw new NullPointerException("managedValue is marked non-null but is null");
            }
            if (managedFeature == null) {
                throw new NullPointerException("managedFeature is marked non-null but is null");
            }
            if (disablingUiModelIfAny == null) {
                throw new NullPointerException("disablingUiModelIfAny is marked non-null but is null");
            }
            this.managedValue = managedValue;
            this.managedFeature = managedFeature;
            this.disablingUiModelIfAny = disablingUiModelIfAny;
        }

        public static ComponentRequest of(@NonNull ManagedValue managedValue, @NonNull ManagedFeature managedFeature, @NonNull Optional<DisablingDecorator.DisablingDecorationModel> disablingUiModelIfAny) {
            if (managedValue == null) {
                throw new NullPointerException("managedValue is marked non-null but is null");
            }
            if (managedFeature == null) {
                throw new NullPointerException("managedFeature is marked non-null but is null");
            }
            if (disablingUiModelIfAny == null) {
                throw new NullPointerException("disablingUiModelIfAny is marked non-null but is null");
            }
            return new ComponentRequest(managedValue, managedFeature, disablingUiModelIfAny);
        }

        @NonNull
        public ManagedValue getManagedValue() {
            return this.managedValue;
        }

        @NonNull
        public ManagedFeature getManagedFeature() {
            return this.managedFeature;
        }

        @NonNull
        public Optional<DisablingDecorator.DisablingDecorationModel> getDisablingUiModelIfAny() {
            return this.disablingUiModelIfAny;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComponentRequest)) {
                return false;
            }
            ComponentRequest other = (ComponentRequest)o;
            ManagedValue this$managedValue = this.getManagedValue();
            ManagedValue other$managedValue = other.getManagedValue();
            if (this$managedValue == null ? other$managedValue != null : !this$managedValue.equals(other$managedValue)) {
                return false;
            }
            ManagedFeature this$managedFeature = this.getManagedFeature();
            ManagedFeature other$managedFeature = other.getManagedFeature();
            if (this$managedFeature == null ? other$managedFeature != null : !this$managedFeature.equals(other$managedFeature)) {
                return false;
            }
            Optional<DisablingDecorator.DisablingDecorationModel> this$disablingUiModelIfAny = this.getDisablingUiModelIfAny();
            Optional<DisablingDecorator.DisablingDecorationModel> other$disablingUiModelIfAny = other.getDisablingUiModelIfAny();
            return !(this$disablingUiModelIfAny == null ? other$disablingUiModelIfAny != null : !((Object)this$disablingUiModelIfAny).equals(other$disablingUiModelIfAny));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ManagedValue $managedValue = this.getManagedValue();
            result = result * 59 + ($managedValue == null ? 43 : $managedValue.hashCode());
            ManagedFeature $managedFeature = this.getManagedFeature();
            result = result * 59 + ($managedFeature == null ? 43 : $managedFeature.hashCode());
            Optional<DisablingDecorator.DisablingDecorationModel> $disablingUiModelIfAny = this.getDisablingUiModelIfAny();
            result = result * 59 + ($disablingUiModelIfAny == null ? 43 : ((Object)$disablingUiModelIfAny).hashCode());
            return result;
        }

        public String toString() {
            return "UiComponentFactory.ComponentRequest(managedValue=" + this.getManagedValue() + ", managedFeature=" + this.getManagedFeature() + ", disablingUiModelIfAny=" + this.getDisablingUiModelIfAny() + ")";
        }
    }

    public static final class ButtonRequest {
        @NonNull
        private final ManagedAction managedAction;
        @NonNull
        private final Optional<DisablingDecorator.DisablingDecorationModel> disablingUiModelIfAny;
        @NonNull
        private final Consumer<ManagedAction> actionEventHandler;

        private ButtonRequest(@NonNull ManagedAction managedAction, @NonNull Optional<DisablingDecorator.DisablingDecorationModel> disablingUiModelIfAny, @NonNull Consumer<ManagedAction> actionEventHandler) {
            if (managedAction == null) {
                throw new NullPointerException("managedAction is marked non-null but is null");
            }
            if (disablingUiModelIfAny == null) {
                throw new NullPointerException("disablingUiModelIfAny is marked non-null but is null");
            }
            if (actionEventHandler == null) {
                throw new NullPointerException("actionEventHandler is marked non-null but is null");
            }
            this.managedAction = managedAction;
            this.disablingUiModelIfAny = disablingUiModelIfAny;
            this.actionEventHandler = actionEventHandler;
        }

        public static ButtonRequest of(@NonNull ManagedAction managedAction, @NonNull Optional<DisablingDecorator.DisablingDecorationModel> disablingUiModelIfAny, @NonNull Consumer<ManagedAction> actionEventHandler) {
            if (managedAction == null) {
                throw new NullPointerException("managedAction is marked non-null but is null");
            }
            if (disablingUiModelIfAny == null) {
                throw new NullPointerException("disablingUiModelIfAny is marked non-null but is null");
            }
            if (actionEventHandler == null) {
                throw new NullPointerException("actionEventHandler is marked non-null but is null");
            }
            return new ButtonRequest(managedAction, disablingUiModelIfAny, actionEventHandler);
        }

        @NonNull
        public ManagedAction getManagedAction() {
            return this.managedAction;
        }

        @NonNull
        public Optional<DisablingDecorator.DisablingDecorationModel> getDisablingUiModelIfAny() {
            return this.disablingUiModelIfAny;
        }

        @NonNull
        public Consumer<ManagedAction> getActionEventHandler() {
            return this.actionEventHandler;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ButtonRequest)) {
                return false;
            }
            ButtonRequest other = (ButtonRequest)o;
            ManagedAction this$managedAction = this.getManagedAction();
            ManagedAction other$managedAction = other.getManagedAction();
            if (this$managedAction == null ? other$managedAction != null : !this$managedAction.equals(other$managedAction)) {
                return false;
            }
            Optional<DisablingDecorator.DisablingDecorationModel> this$disablingUiModelIfAny = this.getDisablingUiModelIfAny();
            Optional<DisablingDecorator.DisablingDecorationModel> other$disablingUiModelIfAny = other.getDisablingUiModelIfAny();
            if (this$disablingUiModelIfAny == null ? other$disablingUiModelIfAny != null : !((Object)this$disablingUiModelIfAny).equals(other$disablingUiModelIfAny)) {
                return false;
            }
            Consumer<ManagedAction> this$actionEventHandler = this.getActionEventHandler();
            Consumer<ManagedAction> other$actionEventHandler = other.getActionEventHandler();
            return !(this$actionEventHandler == null ? other$actionEventHandler != null : !this$actionEventHandler.equals(other$actionEventHandler));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ManagedAction $managedAction = this.getManagedAction();
            result = result * 59 + ($managedAction == null ? 43 : $managedAction.hashCode());
            Optional<DisablingDecorator.DisablingDecorationModel> $disablingUiModelIfAny = this.getDisablingUiModelIfAny();
            result = result * 59 + ($disablingUiModelIfAny == null ? 43 : ((Object)$disablingUiModelIfAny).hashCode());
            Consumer<ManagedAction> $actionEventHandler = this.getActionEventHandler();
            result = result * 59 + ($actionEventHandler == null ? 43 : $actionEventHandler.hashCode());
            return result;
        }

        public String toString() {
            return "UiComponentFactory.ButtonRequest(managedAction=" + this.getManagedAction() + ", disablingUiModelIfAny=" + this.getDisablingUiModelIfAny() + ", actionEventHandler=" + this.getActionEventHandler() + ")";
        }
    }

    public static final class LabelAndPosition<T> {
        @NonNull
        private final LabelPosition labelPosition;
        @NonNull
        private final T uiLabel;

        private LabelAndPosition(@NonNull LabelPosition labelPosition, @NonNull T uiLabel) {
            if (labelPosition == null) {
                throw new NullPointerException("labelPosition is marked non-null but is null");
            }
            if (uiLabel == null) {
                throw new NullPointerException("uiLabel is marked non-null but is null");
            }
            this.labelPosition = labelPosition;
            this.uiLabel = uiLabel;
        }

        public static <T> LabelAndPosition<T> of(@NonNull LabelPosition labelPosition, @NonNull T uiLabel) {
            if (labelPosition == null) {
                throw new NullPointerException("labelPosition is marked non-null but is null");
            }
            if (uiLabel == null) {
                throw new NullPointerException("uiLabel is marked non-null but is null");
            }
            return new LabelAndPosition<T>(labelPosition, uiLabel);
        }

        @NonNull
        public LabelPosition getLabelPosition() {
            return this.labelPosition;
        }

        @NonNull
        public T getUiLabel() {
            return this.uiLabel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LabelAndPosition)) {
                return false;
            }
            LabelAndPosition other = (LabelAndPosition)o;
            LabelPosition this$labelPosition = this.getLabelPosition();
            LabelPosition other$labelPosition = other.getLabelPosition();
            if (this$labelPosition == null ? other$labelPosition != null : !this$labelPosition.equals(other$labelPosition)) {
                return false;
            }
            T this$uiLabel = this.getUiLabel();
            T other$uiLabel = other.getUiLabel();
            return !(this$uiLabel == null ? other$uiLabel != null : !this$uiLabel.equals(other$uiLabel));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LabelPosition $labelPosition = this.getLabelPosition();
            result = result * 59 + ($labelPosition == null ? 43 : $labelPosition.hashCode());
            T $uiLabel = this.getUiLabel();
            result = result * 59 + ($uiLabel == null ? 43 : $uiLabel.hashCode());
            return result;
        }

        public String toString() {
            return "UiComponentFactory.LabelAndPosition(labelPosition=" + this.getLabelPosition() + ", uiLabel=" + this.getUiLabel() + ")";
        }
    }
}

