/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.decorators;

import java.util.Optional;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.applib.services.i18n.TranslationService;
import org.apache.causeway.core.config.messages.MessageRegistry;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.commons.model.layout.UiPlacementDirection;
import org.jspecify.annotations.NonNull;

@FunctionalInterface
public interface ConfirmDecorator<T> {
    public void decorate(T var1, ConfirmDecorationModel var2);

    public record ConfirmDecorationModel(@NonNull String title, @NonNull Optional<String> message, @NonNull String okLabel, @NonNull String cancelLabel, @NonNull UiPlacementDirection placement) {
        public static ConfirmDecorationModel areYouSure(UiPlacementDirection placement) {
            TranslationService translationService = MetaModelContext.translationServiceOrFallback();
            TranslationContext context = TranslationContext.forClassName(MessageRegistry.class);
            String areYouSure = translationService.translate(context, "Are you sure?");
            String confirm = translationService.translate(context, "Confirm");
            String cancel = translationService.translate(context, "Cancel");
            Optional<String> message = Optional.empty();
            return new ConfirmDecorationModel(areYouSure, message, confirm, cancel, placement);
        }
    }
}

