/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.services.menu;

import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import lombok.NonNull;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.layout.component.ServiceActionLayoutData;
import org.apache.causeway.applib.layout.menubars.bootstrap.BSMenu;
import org.apache.causeway.applib.layout.menubars.bootstrap.BSMenuBar;
import org.apache.causeway.applib.layout.menubars.bootstrap.BSMenuSection;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuItemDto;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuVisitor;
import org.apache.causeway.viewer.commons.applib.services.userprof.UserProfileUiModel;
import org.apache.causeway.viewer.commons.services.userprof.UserProfileUiServiceDefault;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class _MenuItemBuilder {
    private static final Logger log = LogManager.getLogger(_MenuItemBuilder.class);

    _MenuItemBuilder() {
    }

    public static void buildMenuItems(MetaModelContext mmc, BSMenuBar menuBar, MenuVisitor menuBuilder) {
        LongAdder itemsPerSectionCounter = new LongAdder();
        MenuProcessor menuVisitor = MenuProcessor.of(mmc, menuBuilder);
        for (BSMenu menu : menuBar.getMenus()) {
            menuVisitor.addTopLevel(menu);
            for (BSMenuSection menuSection : menu.getSections()) {
                itemsPerSectionCounter.reset();
                for (ServiceActionLayoutData actionLayoutData : menuSection.getServiceActions()) {
                    String serviceBeanName = actionLayoutData.getLogicalTypeName();
                    ManagedObject serviceAdapter = mmc.lookupServiceAdapterById(serviceBeanName);
                    if (serviceAdapter == null) continue;
                    ManagedAction managedAction = ManagedAction.lookupAction((ManagedObject)serviceAdapter, (String)actionLayoutData.getId(), (Where)Where.EVERYWHERE).orElse(null);
                    if (managedAction == null) {
                        log.warn("No such action: bean-name '{}' action-id '{}'", (Object)serviceBeanName, (Object)actionLayoutData.getId());
                        continue;
                    }
                    Optional visibilityVeto = managedAction.checkVisibility();
                    if (visibilityVeto.isPresent()) continue;
                    boolean isFirstInSection = itemsPerSectionCounter.intValue() == 0;
                    menuVisitor.addSubMenu(menuSection, managedAction, isFirstInSection, actionLayoutData);
                    itemsPerSectionCounter.increment();
                }
            }
        }
    }

    private static MenuItemDto topLevelDto(MetaModelContext mmc, BSMenu menu) {
        boolean menuItemIsUserProfile = _Strings.isNullOrEmpty((CharSequence)menu.getNamed());
        String menuItemName = menuItemIsUserProfile ? _MenuItemBuilder.userProfileName(mmc) : menu.getNamed();
        return menuItemIsUserProfile ? MenuItemDto.tertiaryRoot((String)menuItemName, (String)menu.getCssClassFa()) : MenuItemDto.topLevel((String)menuItemName, (String)menu.getCssClassFa());
    }

    private static String userProfileName(MetaModelContext mmc) {
        UserProfileUiModel userProfile = ((UserProfileUiServiceDefault)mmc.getServiceRegistry().lookupServiceElseFail(UserProfileUiServiceDefault.class)).userProfile();
        return userProfile.getUserProfileName();
    }

    private static class MenuProcessor {
        private final MetaModelContext metaModelContext;
        private final MenuVisitor menuVisitor;
        private BSMenu currentTopLevel;
        private boolean pushedCurrentTopLevel = false;

        public void addTopLevel(BSMenu menu) {
            this.currentTopLevel = menu;
            this.pushedCurrentTopLevel = false;
        }

        public void addSubMenu(@NonNull BSMenuSection menuSection, @NonNull ManagedAction managedAction, boolean isFirstInSection, ServiceActionLayoutData actionLayoutData) {
            if (menuSection == null) {
                throw new NullPointerException("menuSection is marked non-null but is null");
            }
            if (managedAction == null) {
                throw new NullPointerException("managedAction is marked non-null but is null");
            }
            if (!this.pushedCurrentTopLevel) {
                MenuItemDto topLevelDto = _MenuItemBuilder.topLevelDto(this.metaModelContext, this.currentTopLevel);
                this.menuVisitor.addTopLevel(topLevelDto);
                this.pushedCurrentTopLevel = true;
                if (isFirstInSection && _Strings.isNotEmpty((CharSequence)menuSection.getNamed())) {
                    this.menuVisitor.addSectionLabel(menuSection.getNamed());
                }
            } else if (isFirstInSection) {
                if (_Strings.isEmpty((CharSequence)menuSection.getNamed())) {
                    this.menuVisitor.addSectionSpacer();
                } else {
                    this.menuVisitor.addSectionSpacer();
                    this.menuVisitor.addSectionLabel(menuSection.getNamed());
                }
            }
            MenuItemDto menuDto = MenuItemDto.subMenu((ManagedAction)managedAction, (String)actionLayoutData.getNamed(), (String)actionLayoutData.getCssClassFa());
            this.menuVisitor.addSubMenu(menuDto);
        }

        private MenuProcessor(MetaModelContext metaModelContext, MenuVisitor menuVisitor) {
            this.metaModelContext = metaModelContext;
            this.menuVisitor = menuVisitor;
        }

        public static MenuProcessor of(MetaModelContext metaModelContext, MenuVisitor menuVisitor) {
            return new MenuProcessor(metaModelContext, menuVisitor);
        }
    }
}

