/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneFeature;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Environment;
import org.apache.causeway.viewer.graphql.model.domain.Parent;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ActionInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ObjectInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.query.ObjectFeatureUtils;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionInvoke;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionParams;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionValidity;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichMember;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichMemberDisabled;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichMemberHidden;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RichAction
extends RichMember<ObjectAction, ObjectInteractor>
implements ActionInteractor,
Parent {
    private static final Logger log = LogManager.getLogger(RichAction.class);
    private final RichMemberHidden<ObjectAction> hidden;
    private final RichMemberDisabled<ObjectAction> disabled;
    private final RichActionValidity validate;
    private final RichActionInvoke invoke;
    private final RichActionParams params;

    public RichAction(ObjectInteractor objectInteractor, ObjectAction objectAction, Context context) {
        super(objectInteractor, objectAction, TypeNames.actionTypeNameFor(objectInteractor.getObjectSpecification(), objectAction, objectInteractor.getSchemaType()), context);
        if (this.isBuilt()) {
            this.hidden = null;
            this.disabled = null;
            this.validate = null;
            this.invoke = null;
            this.params = null;
            return;
        }
        this.hidden = new RichMemberHidden<ObjectAction>(this, context);
        this.addChildFieldFor(this.hidden);
        this.disabled = new RichMemberDisabled<ObjectAction>(this, context);
        this.addChildFieldFor(this.disabled);
        this.validate = new RichActionValidity(this, context);
        this.addChildFieldFor(this.validate);
        this.invoke = this.isInvokeAllowed(objectAction) ? new RichActionInvoke(this, context) : null;
        this.addChildFieldFor(this.invoke);
        this.params = new RichActionParams(this, context);
        this.addChildFieldFor(this.params);
        this.buildObjectTypeAndField(objectAction.asciiId(), objectAction.getCanonicalDescription().orElse(objectAction.getCanonicalFriendlyName()));
    }

    private boolean isInvokeAllowed(ObjectAction objectAction) {
        CausewayConfiguration.Viewer.Graphql.ApiVariant apiVariant = this.context.causewayConfiguration.getViewer().getGraphql().getApiVariant();
        switch (apiVariant) {
            case QUERY_ONLY: 
            case QUERY_AND_MUTATIONS: {
                return objectAction.getSemantics().isSafeInNature();
            }
            case QUERY_WITH_MUTATIONS_NON_SPEC_COMPLIANT: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown API variant: " + apiVariant);
    }

    @Override
    public Can<ManagedObject> argumentManagedObjectsFor(Environment dataFetchingEnvironment, ObjectAction objectAction, BookmarkService bookmarkService) {
        return RichAction.argumentManagedObjectsFor(dataFetchingEnvironment, objectAction, this.context);
    }

    public static Can<ManagedObject> argumentManagedObjectsFor(Environment environment, ObjectAction objectAction, Context context) {
        Map<String, Object> argumentPojos = environment.getArguments();
        Can parameters = objectAction.getParameters();
        return parameters.map(oap -> {
            ObjectSpecification elementType = oap.getElementType();
            Object argumentValue = argumentPojos.get(oap.asciiId());
            switch (elementType.getBeanSort()) {
                case VALUE: {
                    return RichAction.adaptValue(oap, argumentValue, context);
                }
                case ENTITY: 
                case VIEW_MODEL: {
                    if (argumentValue == null) {
                        return ManagedObject.empty((ObjectSpecification)elementType);
                    }
                }
                case ABSTRACT: {
                    List pojoOrPojoList;
                    if (argumentValue instanceof List) {
                        List argumentValueList = (List)argumentValue;
                        pojoOrPojoList = argumentValueList.stream().map(value -> RichAction.asPojo(oap.getElementType(), value, environment, context)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                    } else {
                        pojoOrPojoList = RichAction.asPojo(oap.getElementType(), argumentValue, environment, context).orElse(null);
                    }
                    return ManagedObject.adaptParameter((ObjectActionParameter)oap, pojoOrPojoList);
                }
            }
            throw new IllegalArgumentException(String.format("Cannot handle an input type for %s; beanSort is %s", elementType.getFullIdentifier(), elementType.getBeanSort()));
        });
    }

    private static ManagedObject adaptValue(ObjectActionParameter oap, Object argumentValue, Context context) {
        ObjectSpecification elementType = oap.getElementType();
        if (argumentValue == null) {
            return ManagedObject.empty((ObjectSpecification)elementType);
        }
        Object argPojo = context.typeMapper.unmarshal(argumentValue, elementType);
        return ManagedObject.adaptParameter((ObjectActionParameter)oap, (Object)argPojo);
    }

    public static Optional<Object> asPojo(ObjectSpecification elementType, Object argumentValueObj, Environment environment, Context context) {
        Map argumentValue = (Map)argumentValueObj;
        String refValue = (String)argumentValue.get("ref");
        if (refValue != null) {
            String key = ObjectFeatureUtils.keyFor(refValue);
            BookmarkedPojo bookmarkedPojo = (BookmarkedPojo)environment.getGraphQlContext().get((Object)key);
            if (bookmarkedPojo == null) {
                throw new IllegalArgumentException(String.format("Could not find object referenced '%s' in the execution context; was it saved previously using \"saveAs\" ?", refValue));
            }
            Class<?> targetPojoClass = bookmarkedPojo.getTargetPojo().getClass();
            ObjectSpecification targetPojoSpec = context.specificationLoader.loadSpecification(targetPojoClass);
            if (targetPojoSpec == null) {
                throw new IllegalArgumentException(String.format("The object referenced '%s' is not part of the metamodel (has class '%s')", refValue, targetPojoClass.getCanonicalName()));
            }
            if (!elementType.isPojoCompatible(bookmarkedPojo.getTargetPojo())) {
                throw new IllegalArgumentException(String.format("The object referenced '%s' has a type '%s' that is not assignable to the required type '%s'", refValue, targetPojoSpec.getLogicalTypeName(), elementType.getLogicalTypeName()));
            }
            return Optional.of(bookmarkedPojo).map(BookmarkedPojo::getTargetPojo);
        }
        String idValue = (String)argumentValue.get("id");
        if (idValue != null) {
            Optional<Bookmark> bookmarkIfAny;
            Class paramClass = elementType.getCorrespondingClass();
            if (elementType.isAbstract()) {
                ObjectSpecification objectSpecArg = (ObjectSpecification)argumentValue.get("logicalTypeName");
                if (objectSpecArg == null) {
                    throw new IllegalArgumentException(String.format("The 'logicalTypeName' is required along with the 'id', because the input type '%s' is abstract", elementType.getLogicalTypeName()));
                }
                bookmarkIfAny = Optional.of(Bookmark.forLogicalTypeNameAndIdentifier((String)objectSpecArg.getLogicalTypeName(), (String)idValue));
            } else {
                bookmarkIfAny = context.bookmarkService.bookmarkFor(paramClass, idValue);
            }
            return bookmarkIfAny.map(arg_0 -> ((BookmarkService)context.bookmarkService).lookup(arg_0)).filter(Optional::isPresent).map(Optional::get);
        }
        throw new IllegalArgumentException("Either 'id' or 'ref' must be specified for a DomainObject input type");
    }

    @Override
    public void addGqlArguments(ObjectAction objectAction, GraphQLFieldDefinition.Builder builder, TypeMapper.InputContext inputContext, int upTo) {
        Can parameters = objectAction.getParameters();
        List arguments = parameters.stream().limit(upTo).map(objectActionParameter -> this.gqlArgumentFor((ObjectActionParameter)objectActionParameter, inputContext)).collect(Collectors.toList());
        if (!arguments.isEmpty()) {
            builder.arguments(arguments);
        }
    }

    GraphQLArgument gqlArgumentFor(ObjectActionParameter objectActionParameter, TypeMapper.InputContext inputContext) {
        return objectActionParameter.isPlural() ? this.gqlArgumentFor((OneToManyActionParameter)objectActionParameter) : this.gqlArgumentFor((OneToOneActionParameter)objectActionParameter, inputContext);
    }

    GraphQLArgument gqlArgumentFor(OneToOneActionParameter oap, TypeMapper.InputContext inputContext) {
        return GraphQLArgument.newArgument().name(oap.asciiId()).type(this.context.typeMapper.inputTypeFor((OneToOneFeature)oap, inputContext, this.getSchemaType())).build();
    }

    GraphQLArgument gqlArgumentFor(OneToManyActionParameter otmp) {
        return GraphQLArgument.newArgument().name(otmp.asciiId()).type((GraphQLInputType)this.context.typeMapper.inputTypeFor(otmp, this.getSchemaType())).build();
    }

    @Override
    public ObjectSpecification getObjectSpecification() {
        return ((ObjectInteractor)this.interactor).getObjectSpecification();
    }

    @Override
    protected void addDataFetchersForChildren() {
        if (this.hidden == null) {
            return;
        }
        this.hidden.addDataFetcher(this);
        this.disabled.addDataFetcher(this);
        this.validate.addDataFetcher(this);
        if (this.invoke != null) {
            this.invoke.addDataFetcher(this);
        }
        if (this.params != null) {
            this.params.addDataFetcher(this);
        }
    }

    @Override
    public SchemaType getSchemaType() {
        return ((ObjectInteractor)this.interactor).getSchemaType();
    }
}

