/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.registry;

import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class GraphQLTypeRegistry {
    private static final Logger log = LogManager.getLogger(GraphQLTypeRegistry.class);
    private final Provider<Context> contextProvider;
    Set<GraphQLType> graphQLTypes = new HashSet<GraphQLType>();

    public Set<GraphQLType> getGraphQLTypes() {
        return Collections.unmodifiableSet(this.graphQLTypes);
    }

    void addTypeIfNotAlreadyPresent(GraphQLObjectType typeToAdd, String logicalTypeName) {
        if (this.isPresent((GraphQLNamedType)typeToAdd, GraphQLObjectType.class)) {
            log.info("GraphQLObjectType for {} already present", (Object)logicalTypeName);
            return;
        }
        this.graphQLTypes.add((GraphQLType)typeToAdd);
    }

    public GraphQLEnumType addEnumTypeIfNotAlreadyPresent(Class<?> typeToAdd, SchemaType schemaType) {
        ObjectSpecification objectSpec = ((Context)this.contextProvider.get()).specificationLoader.loadSpecification(typeToAdd);
        String typeName = TypeNames.enumTypeNameFor(objectSpec, schemaType);
        Optional<GraphQLEnumType> enumTypeIfAny = this.lookup(typeName, GraphQLEnumType.class);
        if (enumTypeIfAny.isPresent()) {
            return enumTypeIfAny.get();
        }
        Class<?> enumTypeToAdd = typeToAdd;
        GraphQLEnumType enumType = GraphQLEnumType.newEnum().name(typeName).values(Stream.of((Enum[])enumTypeToAdd.getEnumConstants()).map(enumValue -> GraphQLEnumValueDefinition.newEnumValueDefinition().name(enumValue.name()).value(enumValue).build()).collect(Collectors.toList())).build();
        this.add((GraphQLType)enumType);
        return enumType;
    }

    public void addTypeIfNotAlreadyPresent(GraphQLType typeToAdd) {
        if (typeToAdd instanceof GraphQLEnumType) {
            this.addTypeIfNotAlreadyPresent((GraphQLEnumType)typeToAdd);
            return;
        }
        if (typeToAdd instanceof GraphQLObjectType) {
            this.addTypeIfNotAlreadyPresent((GraphQLObjectType)typeToAdd);
            return;
        }
        if (typeToAdd instanceof GraphQLInputObjectType) {
            this.addTypeIfNotAlreadyPresent((GraphQLInputObjectType)typeToAdd);
            return;
        }
        log.warn("GraphQLType {} not yet implemented", (Object)typeToAdd.getClass().getName());
    }

    void addTypeIfNotAlreadyPresent(GraphQLEnumType typeToAdd) {
        if (this.isPresent((GraphQLNamedType)typeToAdd, GraphQLEnumType.class)) {
            log.debug("GraphQLEnumType for {} already present", (Object)typeToAdd.getName());
            return;
        }
        this.add((GraphQLType)typeToAdd);
    }

    void addTypeIfNotAlreadyPresent(GraphQLObjectType typeToAdd) {
        if (this.isPresent((GraphQLNamedType)typeToAdd, GraphQLObjectType.class)) {
            log.debug("GraphQLObjectType for {} already present", (Object)typeToAdd.getName());
            return;
        }
        this.add((GraphQLType)typeToAdd);
    }

    void addTypeIfNotAlreadyPresent(GraphQLInputObjectType typeToAdd) {
        if (this.isPresent((GraphQLNamedType)typeToAdd, GraphQLInputObjectType.class)) {
            log.debug("GraphQLInputObjectType for {} already present", (Object)typeToAdd.getName());
            return;
        }
        this.add((GraphQLType)typeToAdd);
    }

    private boolean isPresent(GraphQLNamedType typeToAdd, Class<? extends GraphQLNamedType> cls) {
        return this.graphQLTypes.stream().filter(o -> o.getClass().isAssignableFrom(cls)).map(cls::cast).anyMatch(ot -> ot.getName().equals(typeToAdd.getName()));
    }

    public <T extends GraphQLNamedType> Optional<T> lookup(String typeName, Class<T> cls) {
        return this.graphQLTypes.stream().filter(o -> o.getClass().isAssignableFrom(cls)).map(cls::cast).filter(ot -> ot.getName().equals(typeName)).findFirst();
    }

    private void add(GraphQLType typeToAdd) {
        this.graphQLTypes.add(typeToAdd);
    }

    @Inject
    public GraphQLTypeRegistry(Provider<Context> contextProvider) {
        this.contextProvider = contextProvider;
    }
}

