/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.context;

import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLType;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.applib.id.HasLogicalType;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.applib.services.registry.ServiceRegistry;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.config.environment.CausewaySystemEnvironment;
import org.apache.causeway.core.metamodel.objectmanager.ObjectManager;
import org.apache.causeway.core.metamodel.spec.ActionScope;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.query.CommonDomainObject;
import org.apache.causeway.viewer.graphql.model.domain.common.query.CommonDomainService;
import org.apache.causeway.viewer.graphql.model.registry.GraphQLTypeRegistry;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;
import org.springframework.stereotype.Component;

@Component
public class Context {
    public final GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry();
    public final BookmarkService bookmarkService;
    public final SpecificationLoader specificationLoader;
    public final TypeMapper typeMapper;
    public final ServiceRegistry serviceRegistry;
    public final CausewayConfiguration causewayConfiguration;
    public final CausewaySystemEnvironment causewaySystemEnvironment;
    public final ObjectManager objectManager;
    public final GraphQLTypeRegistry graphQLTypeRegistry;
    public final Map<String, CommonDomainService> domainServiceByTypeName = new LinkedHashMap<String, CommonDomainService>();
    public final Map<String, CommonDomainObject> domainObjectByTypeName = new LinkedHashMap<String, CommonDomainObject>();
    private GraphQLEnumType logicalTypeNames;

    public GraphQLEnumType getLogicalTypeNames() {
        if (this.logicalTypeNames == null) {
            this.computeLogicalTypeNames();
        }
        return this.logicalTypeNames;
    }

    public ImmutableEnumSet<ActionScope> getActionScope() {
        return this.causewaySystemEnvironment.getDeploymentType().isProduction() ? ActionScope.PRODUCTION_ONLY : ActionScope.ANY;
    }

    public List<ObjectSpecification> objectSpecifications() {
        return this.objectSpecifications(spec -> true);
    }

    public List<ObjectSpecification> objectSpecifications(Predicate<ObjectSpecification> predicate) {
        boolean includeEntities = this.causewayConfiguration.getViewer().getGraphql().getApiScope() == CausewayConfiguration.Viewer.Graphql.ApiScope.ALL;
        return this.specificationLoader.snapshotSpecifications().filter(x -> x.getCorrespondingClass().getPackage() != Either.class.getPackage()).distinct((a, b) -> a.getLogicalTypeName().equals(b.getLogicalTypeName())).filter(x -> x.isViewModel() || includeEntities && x.isEntity() || includeEntities && x.isAbstract() || x.getBeanSort().isManagedBeanContributing()).filter(predicate).sorted(Comparator.comparing(HasLogicalType::getLogicalTypeName)).toList();
    }

    private void computeLogicalTypeNames() {
        if (this.logicalTypeNames != null) {
            return;
        }
        this.logicalTypeNames = this.doComputeLogicalTypeNames();
        this.graphQLTypeRegistry.addTypeIfNotAlreadyPresent((GraphQLType)this.logicalTypeNames);
    }

    private GraphQLEnumType doComputeLogicalTypeNames() {
        List<ObjectSpecification> entitiesOrViewModels = this.objectSpecifications(ObjectSpecification::isEntityOrViewModel);
        return GraphQLEnumType.newEnum().name("logicalTypeNames__gqlv_enum").values(entitiesOrViewModels.stream().map(objectSpec -> GraphQLEnumValueDefinition.newEnumValueDefinition().name(TypeNames.objectTypeFieldNameFor(objectSpec)).description(objectSpec.getLogicalTypeName()).value(objectSpec).build()).collect(Collectors.toList())).build();
    }

    @Generated
    public Context(BookmarkService bookmarkService, SpecificationLoader specificationLoader, TypeMapper typeMapper, ServiceRegistry serviceRegistry, CausewayConfiguration causewayConfiguration, CausewaySystemEnvironment causewaySystemEnvironment, ObjectManager objectManager, GraphQLTypeRegistry graphQLTypeRegistry) {
        this.bookmarkService = bookmarkService;
        this.specificationLoader = specificationLoader;
        this.typeMapper = typeMapper;
        this.serviceRegistry = serviceRegistry;
        this.causewayConfiguration = causewayConfiguration;
        this.causewaySystemEnvironment = causewaySystemEnvironment;
        this.objectManager = objectManager;
        this.graphQLTypeRegistry = graphQLTypeRegistry;
    }
}

