/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.simple.mutation;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.causeway.core.metamodel.interactions.InteractionHead;
import org.apache.causeway.core.metamodel.interactions.managed.ActionInteractionHead;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneFeature;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.Environment;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.query.ObjectFeatureUtils;
import org.apache.causeway.viewer.graphql.model.exceptions.DisabledException;
import org.apache.causeway.viewer.graphql.model.exceptions.HiddenException;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.Nullable;

public class SimpleMutationForAction
extends Element {
    @Generated
    private static final Logger log = LogManager.getLogger(SimpleMutationForAction.class);
    private static final SchemaType SCHEMA_TYPE = SchemaType.SIMPLE;
    private final ObjectSpecification objectSpec;
    private final ObjectAction objectAction;
    private String argumentName;

    public SimpleMutationForAction(ObjectSpecification objectSpec, ObjectAction objectAction, Context context) {
        super(context);
        this.objectSpec = objectSpec;
        this.objectAction = objectAction;
        this.argumentName = context.causewayConfiguration.getViewer().getGraphql().getMutation().getTargetArgName();
        GraphQLOutputType type = this.typeFor(objectAction);
        if (type != null) {
            GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(SimpleMutationForAction.fieldName(objectSpec, objectAction)).type(type);
            this.addGqlArguments(fieldBuilder);
            this.setField(fieldBuilder.build());
        } else {
            this.setField(null);
        }
    }

    private static String fieldName(ObjectSpecification objectSpecification, ObjectAction oa) {
        return TypeNames.objectTypeFieldNameFor(objectSpecification) + "__" + oa.asciiId();
    }

    @Nullable
    private GraphQLOutputType typeFor(ObjectAction objectAction) {
        ObjectSpecification objectSpecification = objectAction.getReturnType();
        switch (objectSpecification.getBeanSort()) {
            case COLLECTION: {
                TypeOfFacet facet = (TypeOfFacet)objectAction.getFacet(TypeOfFacet.class);
                if (facet == null) {
                    log.warn("Unable to locate TypeOfFacet for {}", (Object)objectAction.getFeatureIdentifier().getFullIdentityString());
                    return null;
                }
                ObjectSpecification objectSpecificationOfCollectionElement = facet.elementSpec();
                GraphQLOutputType wrappedType = this.context.typeMapper.outputTypeFor(objectSpecificationOfCollectionElement, SchemaType.RICH);
                if (wrappedType == null) {
                    log.warn("Unable to create wrapped type of for {} for action {}", (Object)objectSpecificationOfCollectionElement.getFullIdentifier(), (Object)objectAction.getFeatureIdentifier().getFullIdentityString());
                    return null;
                }
                return GraphQLList.list((GraphQLType)wrappedType);
            }
        }
        return this.context.typeMapper.outputTypeFor(objectSpecification, SchemaType.RICH);
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        Can<ManagedObject> argumentManagedObjects;
        Object sourcePojo;
        boolean isService = this.objectSpec.getBeanSort().isManagedBeanContributing();
        Environment.For environment = new Environment.For(dataFetchingEnvironment);
        if (isService) {
            sourcePojo = this.context.serviceRegistry.lookupServiceElseFail(this.objectSpec.getCorrespondingClass());
        } else {
            Optional<Object> result;
            Object target = dataFetchingEnvironment.getArgument(this.argumentName);
            Map argumentValue = (Map)target;
            String idValue = (String)argumentValue.get("id");
            if (idValue != null) {
                Optional bookmarkIfAny;
                ObjectSpecification objectSpecArg = (ObjectSpecification)argumentValue.get("logicalTypeName");
                if (objectSpecArg != null) {
                    bookmarkIfAny = Optional.of(Bookmark.forLogicalTypeNameAndIdentifier((String)objectSpecArg.getLogicalTypeName(), (String)idValue));
                } else {
                    Class paramClass = this.objectSpec.getCorrespondingClass();
                    bookmarkIfAny = this.context.bookmarkService.bookmarkFor(paramClass, idValue);
                }
                result = bookmarkIfAny.map(arg_0 -> ((BookmarkService)this.context.bookmarkService).lookup(arg_0)).filter(Optional::isPresent).map(Optional::get);
            } else {
                String refValue = (String)argumentValue.get("ref");
                if (refValue != null) {
                    String key = ObjectFeatureUtils.keyFor(refValue);
                    BookmarkedPojo value = (BookmarkedPojo)environment.getGraphQlContext().get((Object)key);
                    result = Optional.of(value).map(BookmarkedPojo::getTargetPojo);
                } else {
                    throw new IllegalArgumentException("Either 'id' or 'ref' must be specified for a DomainObject input type");
                }
            }
            sourcePojo = result.orElseThrow();
        }
        ManagedObject managedObject = ManagedObject.adaptSingular((ObjectSpecification)this.objectSpec, (Object)sourcePojo);
        Consent visibleConsent = this.objectAction.isVisible(managedObject, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (visibleConsent.isVetoed()) {
            throw new HiddenException(this.objectAction.getFeatureIdentifier());
        }
        Consent usableConsent = this.objectAction.isUsable(managedObject, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (usableConsent.isVetoed()) {
            throw new DisabledException(this.objectAction.getFeatureIdentifier());
        }
        ActionInteractionHead head = this.objectAction.interactionHead(managedObject);
        Consent validityConsent = this.objectAction.isArgumentSetValid((InteractionHead)head, argumentManagedObjects = this.argumentManagedObjectsFor(environment, this.objectAction), InteractionInitiatedBy.USER);
        if (validityConsent.isVetoed()) {
            throw new IllegalArgumentException(validityConsent.getReasonAsString().orElse("Invalid"));
        }
        ManagedObject resultManagedObject = this.objectAction.execute((InteractionHead)head, argumentManagedObjects, InteractionInitiatedBy.USER);
        return resultManagedObject.getPojo();
    }

    private void addGqlArguments(GraphQLFieldDefinition.Builder fieldBuilder) {
        ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
        String argName = this.context.causewayConfiguration.getViewer().getGraphql().getMutation().getTargetArgName();
        if (!this.objectSpec.getBeanSort().isManagedBeanContributing()) {
            arguments.add(GraphQLArgument.newArgument().name(argName).type(this.context.typeMapper.inputTypeFor(this.objectSpec, SchemaType.RICH)).build());
        }
        Can parameters = this.objectAction.getParameters();
        parameters.stream().map(this::gqlArgumentFor).forEach(arguments::add);
        if (!arguments.isEmpty()) {
            fieldBuilder.arguments(arguments);
        }
    }

    GraphQLArgument gqlArgumentFor(ObjectActionParameter objectActionParameter) {
        return objectActionParameter.isPlural() ? this.gqlArgumentFor((OneToManyActionParameter)objectActionParameter) : this.gqlArgumentFor((OneToOneActionParameter)objectActionParameter);
    }

    GraphQLArgument gqlArgumentFor(OneToOneActionParameter otoap) {
        return GraphQLArgument.newArgument().name(otoap.asciiId()).type(this.context.typeMapper.inputTypeFor((OneToOneFeature)otoap, TypeMapper.InputContext.INVOKE, SchemaType.RICH)).build();
    }

    GraphQLArgument gqlArgumentFor(OneToManyActionParameter otmap) {
        return GraphQLArgument.newArgument().name(otmap.asciiId()).type((GraphQLInputType)this.context.typeMapper.inputTypeFor(otmap, SchemaType.RICH)).build();
    }

    private Can<ManagedObject> argumentManagedObjectsFor(Environment dataFetchingEnvironment, ObjectAction objectAction) {
        return ObjectFeatureUtils.argumentManagedObjectsFor(dataFetchingEnvironment, objectAction, this.context);
    }
}

