/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.common.query;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.SchemaStrategy;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ObjectInteractor;

public class CommonDomainService
extends ElementCustom
implements ObjectInteractor {
    private final SchemaStrategy schemaStrategy;
    private final ObjectSpecification objectSpecification;
    private final Object servicePojo;
    private final List<Element> actions = new ArrayList<Element>();

    @Override
    public SchemaType getSchemaType() {
        return this.schemaStrategy.getSchemaType();
    }

    public static String typeNameFor(SchemaStrategy schemaStrategy, ObjectSpecification objectSpecification) {
        return TypeNames.objectTypeNameFor(objectSpecification, schemaStrategy.getSchemaType());
    }

    public CommonDomainService(SchemaStrategy schemaStrategy, String typeName, ObjectSpecification objectSpecification, Object servicePojo, Context context) {
        super(typeName, context);
        this.schemaStrategy = schemaStrategy;
        this.objectSpecification = objectSpecification;
        this.servicePojo = servicePojo;
        if (this.isBuilt()) {
            return;
        }
        this.addActions();
        if (this.hasActions()) {
            this.buildObjectTypeAndField(TypeNames.objectTypeFieldNameFor(this.objectSpecification), this.objectSpecification.getDescription());
        }
    }

    public boolean hasActions() {
        return !this.actions.isEmpty();
    }

    private void addActions() {
        CausewayConfiguration.Viewer.Graphql.ApiVariant apiVariant = this.context.causewayConfiguration.getViewer().getGraphql().getApiVariant();
        CausewayConfiguration.Viewer.Graphql.ApiVariant apiScope = this.context.causewayConfiguration.getViewer().getGraphql().getApiVariant();
        this.objectSpecification.streamActions(this.context.getActionScope(), MixedIn.INCLUDED).filter(x$0 -> this.inApiScope((ObjectAction)x$0)).filter(objectAction -> objectAction.getSemantics().isSafeInNature() || apiVariant != CausewayConfiguration.Viewer.Graphql.ApiVariant.QUERY_ONLY).forEach(act -> this.actions.add(this.addChildFieldFor(this.schemaStrategy.newAction(this, (ObjectAction)act, this.context))));
    }

    @Override
    protected void addDataFetchersForChildren() {
        if (this.hasActions()) {
            this.actions.forEach(act -> act.addDataFetcher(this));
        }
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment environment) {
        return this.getServicePojo();
    }

    public String toString() {
        return this.objectSpecification.getLogicalTypeName();
    }

    public SchemaStrategy getSchemaStrategy() {
        return this.schemaStrategy;
    }

    @Override
    public ObjectSpecification getObjectSpecification() {
        return this.objectSpecification;
    }

    public Object getServicePojo() {
        return this.servicePojo;
    }
}

