/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.Environment;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ActionInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ActionParamInteractor;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionParamsParamAutoComplete;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionParamsParamChoices;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionParamsParamDatatype;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionParamsParamDefault;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionParamsParamDisabled;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionParamsParamHidden;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichActionParamsParamValidate;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;
import org.apache.causeway.viewer.graphql.model.mmproviders.ObjectActionParameterProvider;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RichActionParamsParam
extends ElementCustom
implements ActionParamInteractor,
ObjectActionParameterProvider {
    private static final Logger log = LogManager.getLogger(RichActionParamsParam.class);
    private final ActionInteractor actionInteractor;
    private final ObjectActionParameter objectActionParameter;
    private final int paramNum;
    private final RichActionParamsParamHidden hidden;
    private final RichActionParamsParamDisabled disabled;
    private final RichActionParamsParamChoices choices;
    private final RichActionParamsParamAutoComplete autoComplete;
    private final RichActionParamsParamDefault default_;
    private final RichActionParamsParamValidate validate;
    private final RichActionParamsParamDatatype datatype;

    public RichActionParamsParam(ActionInteractor holder, ObjectActionParameter oap, Context context, int paramNum) {
        super(TypeNames.actionParamTypeNameFor(holder.getObjectSpecification(), oap, holder.getSchemaType()), context);
        this.actionInteractor = holder;
        this.objectActionParameter = oap;
        this.paramNum = paramNum;
        if (this.isBuilt()) {
            this.hidden = null;
            this.disabled = null;
            this.choices = null;
            this.autoComplete = null;
            this.default_ = null;
            this.validate = null;
            this.datatype = null;
            return;
        }
        this.hidden = new RichActionParamsParamHidden(this, context);
        this.addChildFieldFor(this.hidden);
        this.disabled = new RichActionParamsParamDisabled(this, context);
        this.addChildFieldFor(this.disabled);
        this.choices = new RichActionParamsParamChoices(this, context);
        this.addChildFieldFor(this.choices);
        this.autoComplete = new RichActionParamsParamAutoComplete(this, context);
        this.addChildFieldFor(this.autoComplete);
        this.default_ = new RichActionParamsParamDefault(this, context);
        this.addChildFieldFor(this.default_);
        this.validate = new RichActionParamsParamValidate(this, context);
        this.addChildFieldFor(this.validate);
        this.datatype = new RichActionParamsParamDatatype(this, context);
        this.addChildFieldFor(this.datatype);
        this.buildObjectTypeAndField(oap.asciiId(), oap.getCanonicalDescription().orElse(oap.getCanonicalFriendlyName()));
    }

    @Override
    public ObjectSpecification getObjectSpecification() {
        return this.actionInteractor.getObjectSpecification();
    }

    @Override
    public ObjectAction getObjectMember() {
        return (ObjectAction)this.actionInteractor.getObjectMember();
    }

    @Override
    protected void addDataFetchersForChildren() {
        if (this.hidden == null) {
            return;
        }
        this.hidden.addDataFetcher(this);
        this.disabled.addDataFetcher(this);
        if (this.choices != null) {
            this.choices.addDataFetcher(this);
        }
        if (this.autoComplete != null) {
            this.autoComplete.addDataFetcher(this);
        }
        if (this.default_ != null) {
            this.default_.addDataFetcher(this);
        }
        this.validate.addDataFetcher(this);
        this.datatype.addDataFetcher(this);
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        return BookmarkedPojo.sourceFrom(dataFetchingEnvironment, this.context);
    }

    @Override
    public void addGqlArguments(ObjectAction objectAction, GraphQLFieldDefinition.Builder fieldBuilder, TypeMapper.InputContext inputContext, int paramNum) {
        this.actionInteractor.addGqlArguments(objectAction, fieldBuilder, inputContext, paramNum);
    }

    @Override
    public Can<ManagedObject> argumentManagedObjectsFor(Environment environment, ObjectAction objectAction, BookmarkService bookmarkService) {
        return this.actionInteractor.argumentManagedObjectsFor(environment, objectAction, bookmarkService);
    }

    @Override
    public void addGqlArgument(ObjectAction objectAction, GraphQLFieldDefinition.Builder fieldBuilder, TypeMapper.InputContext inputContext, int paramNum) {
    }

    @Override
    public SchemaType getSchemaType() {
        return this.actionInteractor.getSchemaType();
    }

    @Override
    public ActionInteractor getActionInteractor() {
        return this.actionInteractor;
    }

    @Override
    public ObjectActionParameter getObjectActionParameter() {
        return this.objectActionParameter;
    }

    @Override
    public int getParamNum() {
        return this.paramNum;
    }
}

