/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.causeway.core.metamodel.interactions.InteractionHead;
import org.apache.causeway.core.metamodel.interactions.managed.ActionInteractionHead;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.Environment;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ActionInteractor;
import org.apache.causeway.viewer.graphql.model.exceptions.DisabledException;
import org.apache.causeway.viewer.graphql.model.exceptions.HiddenException;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class RichActionInvokeResult
extends Element {
    @Generated
    private static final Logger log = LogManager.getLogger(RichActionInvokeResult.class);
    private final ActionInteractor actionInteractor;

    public RichActionInvokeResult(ActionInteractor actionInteractor, Context context) {
        super(context);
        this.actionInteractor = actionInteractor;
        ObjectAction objectAction = (ObjectAction)actionInteractor.getObjectMember();
        GraphQLOutputType graphQLOutputType = this.typeFor(objectAction);
        if (graphQLOutputType != null) {
            GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name("results").type(graphQLOutputType);
            this.setField(fieldBuilder.build());
        } else {
            this.setField(null);
        }
    }

    private @Nullable GraphQLOutputType typeFor(ObjectAction objectAction) {
        ObjectSpecification objectSpecification = objectAction.getReturnType();
        switch (objectSpecification.getBeanSort()) {
            case COLLECTION: {
                TypeOfFacet facet = (TypeOfFacet)objectAction.getFacet(TypeOfFacet.class);
                if (facet == null) {
                    log.warn("Unable to locate TypeOfFacet for {}", (Object)objectAction.getFeatureIdentifier().getFullIdentityString());
                    return null;
                }
                ObjectSpecification objectSpecificationOfCollectionElement = facet.elementSpec();
                GraphQLOutputType wrappedType = this.context.typeMapper.outputTypeFor(objectSpecificationOfCollectionElement, this.actionInteractor.getSchemaType());
                if (wrappedType == null) {
                    log.warn("Unable to create wrapped type of for {} for action {}", (Object)objectSpecificationOfCollectionElement.getFullIdentifier(), (Object)objectAction.getFeatureIdentifier().getFullIdentityString());
                    return null;
                }
                return GraphQLList.list((GraphQLType)wrappedType);
            }
        }
        return this.context.typeMapper.outputTypeFor(objectSpecification, this.actionInteractor.getSchemaType());
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        Can<ManagedObject> argumentManagedObjects;
        ManagedObject managedObject;
        Object sourcePojo = BookmarkedPojo.sourceFrom(dataFetchingEnvironment);
        Environment.ForTunnelled environment = new Environment.ForTunnelled(dataFetchingEnvironment);
        ObjectSpecification objectSpecification = this.context.specificationLoader.loadSpecification(sourcePojo.getClass());
        if (objectSpecification == null) {
            return null;
        }
        ObjectAction objectAction = (ObjectAction)this.actionInteractor.getObjectMember();
        Consent visibleConsent = objectAction.isVisible(managedObject = ManagedObject.adaptSingular((ObjectSpecification)objectSpecification, (Object)sourcePojo), InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (visibleConsent.isVetoed()) {
            throw new HiddenException(objectAction.getFeatureIdentifier());
        }
        Consent usableConsent = objectAction.isUsable(managedObject, InteractionInitiatedBy.USER, Where.ANYWHERE);
        if (usableConsent.isVetoed()) {
            throw new DisabledException(objectAction.getFeatureIdentifier());
        }
        ActionInteractionHead head = objectAction.interactionHead(managedObject);
        Consent validityConsent = objectAction.isArgumentSetValid((InteractionHead)head, argumentManagedObjects = this.actionInteractor.argumentManagedObjectsFor(environment, objectAction, this.context.bookmarkService), InteractionInitiatedBy.USER);
        if (validityConsent.isVetoed()) {
            throw new IllegalArgumentException(validityConsent.getReasonAsString().orElse("Invalid"));
        }
        ManagedObject resultManagedObject = objectAction.execute((InteractionHead)head, argumentManagedObjects, InteractionInitiatedBy.USER);
        return resultManagedObject.getPojo();
    }
}

