/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain;

import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.Parent;
import org.jspecify.annotations.Nullable;

public abstract class ElementCustom
extends Element
implements Parent {
    private final String typeName;
    protected final GraphQLObjectType.Builder gqlObjectTypeBuilder;
    private GraphQLObjectType gqlObjectType;

    protected ElementCustom(String typeName, Context context) {
        super(context);
        this.typeName = typeName;
        Optional<GraphQLObjectType> typeIfAny = context.graphQLTypeRegistry.lookup(typeName, GraphQLObjectType.class);
        if (typeIfAny.isPresent()) {
            this.gqlObjectType = typeIfAny.get();
            this.gqlObjectTypeBuilder = null;
        } else {
            this.gqlObjectTypeBuilder = GraphQLObjectType.newObject().name(typeName);
        }
    }

    public boolean isBuilt() {
        return this.gqlObjectType != null;
    }

    protected final <T extends Element> T addChildFieldFor(@Nullable T hasField) {
        if (this.isBuilt()) {
            return hasField;
        }
        if (hasField == null) {
            return hasField;
        }
        this.addChildField(hasField.getField());
        return hasField;
    }

    protected void addChildField(GraphQLFieldDefinition childField) {
        if (this.isBuilt()) {
            return;
        }
        if (childField != null) {
            this.gqlObjectTypeBuilder.field(childField);
        }
    }

    protected void buildObjectTypeAndField(String fieldName, String description) {
        if (!this.isBuilt()) {
            this.buildObjectType();
        }
        this.setField(this.newField(fieldName, description));
    }

    public GraphQLFieldDefinition newField(String fieldName, String description) {
        return GraphQLFieldDefinition.newFieldDefinition().name(fieldName).description(description).type((GraphQLOutputType)this.getGqlObjectType()).build();
    }

    protected final GraphQLObjectType buildObjectType() {
        if (!this.isBuilt()) {
            this.gqlObjectType = this.gqlObjectTypeBuilder.build();
            this.context.graphQLTypeRegistry.addTypeIfNotAlreadyPresent((GraphQLType)this.gqlObjectType);
        }
        return this.gqlObjectType;
    }

    public void addDataFetchers() {
    }

    @Override
    public final FieldCoordinates coordinatesFor(GraphQLFieldDefinition field) {
        if (this.gqlObjectType == null) {
            throw new IllegalStateException(String.format("GQL Object Type for '%s' not yet built", this.typeName));
        }
        return FieldCoordinates.coordinates((GraphQLFieldsContainer)this.gqlObjectType, (GraphQLFieldDefinition)field);
    }

    @Override
    public final FieldCoordinates coordinatesFor(String fieldName) {
        if (this.gqlObjectType == null) {
            throw new IllegalStateException(String.format("GQL Object Type for '%s' not yet built", this.typeName));
        }
        return FieldCoordinates.coordinates((GraphQLFieldsContainer)this.gqlObjectType, (String)fieldName);
    }

    protected boolean inApiScope(ObjectAction act) {
        if (this.graphqlConfiguration.getApiScope() == CausewayConfiguration.Viewer.Graphql.ApiScope.ALL) {
            return true;
        }
        ObjectSpecification returnType = act.getElementType();
        return returnType.isViewModelOrValueOrVoid() && act.getParameterTypes().stream().allMatch(ObjectSpecification::isViewModelOrValue);
    }

    protected boolean inApiScope(ObjectAssociation objAssoc) {
        if (this.graphqlConfiguration.getApiScope() == CausewayConfiguration.Viewer.Graphql.ApiScope.ALL) {
            return true;
        }
        return objAssoc.getElementType().isViewModelOrValue();
    }

    @Generated
    public GraphQLObjectType getGqlObjectType() {
        return this.gqlObjectType;
    }
}

