/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.common.query.meta;

import java.util.Optional;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.causeway.core.metamodel.facets.object.entity.EntityFacet;
import org.apache.causeway.core.metamodel.facets.object.layout.LayoutPrefixFacet;
import org.apache.causeway.core.metamodel.object.Bookmarkable;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.objectmanager.ObjectManager;

public class CommonMetaFetcher {
    private final Bookmark bookmark;
    private final BookmarkService bookmarkService;
    private final ObjectManager objectManager;
    private final CausewayConfiguration causewayConfiguration;
    private final String graphqlPath;

    public CommonMetaFetcher(Bookmark bookmark, BookmarkService bookmarkService, ObjectManager objectManager, CausewayConfiguration causewayConfiguration) {
        this.bookmark = bookmark;
        this.bookmarkService = bookmarkService;
        this.objectManager = objectManager;
        this.causewayConfiguration = causewayConfiguration;
        this.graphqlPath = causewayConfiguration.valueOf("spring.graphql.path").orElse("/graphql");
    }

    public String logicalTypeName() {
        return this.bookmark.logicalTypeName();
    }

    public String id() {
        return this.bookmark.identifier();
    }

    public String version() {
        return this.managedObject().map(managedObject -> {
            Object domainPojo = managedObject.getPojo();
            EntityFacet entityFacet = (EntityFacet)managedObject.objSpec().getFacet(EntityFacet.class);
            if (entityFacet != null) {
                Object object = entityFacet.versionOf(domainPojo);
                return object != null ? object.toString() : null;
            }
            return null;
        }).orElse(null);
    }

    public Bookmark bookmark() {
        return this.bookmark;
    }

    public String title() {
        return this.managedObject().map(ManagedObject::getTitle).orElse(null);
    }

    public String cssClass() {
        return this.managedObject().map(managedObject -> {
            CssClassFacet facet = (CssClassFacet)managedObject.objSpec().getFacet(CssClassFacet.class);
            return facet != null ? facet.cssClass(managedObject) : null;
        }).orElse(null);
    }

    public String layout() {
        return this.managedObject().map(managedObject -> {
            LayoutPrefixFacet facet = (LayoutPrefixFacet)managedObject.objSpec().getFacet(LayoutPrefixFacet.class);
            return facet != null ? facet.layoutPrefix(managedObject) : null;
        }).orElse(null);
    }

    public String grid() {
        return this.resource("grid");
    }

    public String icon() {
        return this.resource("icon");
    }

    private String resource(String resource) {
        return this.managedObject().flatMap(Bookmarkable::getBookmark).map(bookmark -> String.format("//%s/object/%s:%s/%s/%s", this.graphqlPath, bookmark.logicalTypeName(), bookmark.identifier(), this.causewayConfiguration.getViewer().getGraphql().getMetaData().getFieldName(), resource)).orElse(null);
    }

    private Optional<ManagedObject> managedObject() {
        return this.bookmarkService.lookup(this.bookmark).map(arg_0 -> ((ObjectManager)this.objectManager).adapt(arg_0));
    }
}

