/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.common.query;

import graphql.schema.DataFetchingEnvironment;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.metamodel.BeanSort;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ObjectInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.query.meta.CommonMetaCssClass;
import org.apache.causeway.viewer.graphql.model.domain.common.query.meta.CommonMetaFetcher;
import org.apache.causeway.viewer.graphql.model.domain.common.query.meta.CommonMetaGrid;
import org.apache.causeway.viewer.graphql.model.domain.common.query.meta.CommonMetaIcon;
import org.apache.causeway.viewer.graphql.model.domain.common.query.meta.CommonMetaId;
import org.apache.causeway.viewer.graphql.model.domain.common.query.meta.CommonMetaLayout;
import org.apache.causeway.viewer.graphql.model.domain.common.query.meta.CommonMetaLogicalTypeName;
import org.apache.causeway.viewer.graphql.model.domain.common.query.meta.CommonMetaSaveAs;
import org.apache.causeway.viewer.graphql.model.domain.common.query.meta.CommonMetaTitle;
import org.apache.causeway.viewer.graphql.model.domain.common.query.meta.CommonMetaVersion;

public class CommonMeta
extends ElementCustom {
    private final ObjectInteractor holder;
    private final CommonMetaId metaId;
    private final CommonMetaLogicalTypeName metaLogicalTypeName;
    private final CommonMetaVersion metaVersion;
    private final CommonMetaTitle metaTitle;
    private final CommonMetaIcon metaIcon;
    private final CommonMetaCssClass metaCssClass;
    private final CommonMetaLayout metaLayout;
    private final CommonMetaGrid metaGrid;
    private final CommonMetaSaveAs metaSaveAs;
    private final CausewayConfiguration.Viewer.Graphql graphqlConfiguration;

    public CommonMeta(ObjectInteractor objectInteractor, Context context) {
        super(TypeNames.metaTypeNameFor(objectInteractor.getObjectSpecification(), objectInteractor.getSchemaType()), context);
        this.holder = objectInteractor;
        this.graphqlConfiguration = context.causewayConfiguration.getViewer().getGraphql();
        if (this.isBuilt()) {
            this.metaId = null;
            this.metaLogicalTypeName = null;
            this.metaVersion = null;
            this.metaTitle = null;
            this.metaIcon = null;
            this.metaCssClass = null;
            this.metaLayout = null;
            this.metaGrid = null;
            this.metaSaveAs = null;
            return;
        }
        this.metaId = new CommonMetaId(context);
        this.addChildFieldFor(this.metaId);
        this.metaLogicalTypeName = new CommonMetaLogicalTypeName(context);
        this.addChildFieldFor(this.metaLogicalTypeName);
        this.metaVersion = this.isEntity() ? new CommonMetaVersion(context) : null;
        this.addChildFieldFor(this.metaVersion);
        this.metaTitle = new CommonMetaTitle(context);
        this.addChildFieldFor(this.metaTitle);
        this.metaCssClass = new CommonMetaCssClass(context);
        this.addChildFieldFor(this.metaCssClass);
        this.metaLayout = new CommonMetaLayout(context);
        this.addChildFieldFor(this.metaLayout);
        this.metaSaveAs = new CommonMetaSaveAs(context);
        this.addChildFieldFor(this.metaSaveAs);
        this.metaIcon = this.isResourceNotForbidden() ? new CommonMetaIcon(context) : null;
        this.addChildFieldFor(this.metaIcon);
        this.metaGrid = this.isResourceNotForbidden() ? new CommonMetaGrid(context) : null;
        this.addChildFieldFor(this.metaGrid);
        String fieldName = this.graphqlConfiguration.getMetaData().getFieldName();
        this.buildObjectTypeAndField(fieldName, "Object metadata");
    }

    private boolean isResourceNotForbidden() {
        return this.graphqlConfiguration.getResources().getResponseType() != CausewayConfiguration.Viewer.Graphql.ResponseType.FORBIDDEN;
    }

    private boolean isEntity() {
        return this.holder.getObjectSpecification().getBeanSort() == BeanSort.ENTITY;
    }

    @Override
    protected void addDataFetchersForChildren() {
        if (this.metaId == null) {
            return;
        }
        this.metaId.addDataFetcher(this);
        this.metaLogicalTypeName.addDataFetcher(this);
        if (this.isEntity()) {
            this.metaVersion.addDataFetcher(this);
        }
        this.metaTitle.addDataFetcher(this);
        this.metaCssClass.addDataFetcher(this);
        this.metaLayout.addDataFetcher(this);
        this.metaSaveAs.addDataFetcher(this);
        if (this.metaGrid != null) {
            this.metaGrid.addDataFetcher(this);
        }
        if (this.metaIcon != null) {
            this.metaIcon.addDataFetcher(this);
        }
    }

    @Override
    public Object fetchData(DataFetchingEnvironment environment) {
        return this.context.bookmarkService.bookmarkFor(environment.getSource()).map(bookmark -> new CommonMetaFetcher((Bookmark)bookmark, this.context.bookmarkService, this.context.objectManager, this.context.causewayConfiguration)).orElseThrow();
    }
}

