/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.types;

import graphql.Scalars;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import lombok.Generated;
import org.apache.causeway.applib.services.metamodel.BeanSort;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneFeature;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.types.ScalarMapper;
import org.apache.causeway.viewer.graphql.model.types.TypeMapper;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class TypeMapperDefault
implements TypeMapper {
    private final ScalarMapper scalarMapper;
    private final Provider<Context> contextProvider;

    @Override
    public GraphQLOutputType outputTypeFor(Class<?> clazz) {
        if (clazz.isEnum()) {
            return ((Context)this.contextProvider.get()).graphQLTypeRegistry.addEnumTypeIfNotAlreadyPresent(clazz, SchemaType.RICH);
        }
        return this.scalarMapper.scalarTypeFor(clazz);
    }

    @Override
    public GraphQLInputType inputTypeFor(Class<?> clazz) {
        if (clazz.isEnum()) {
            return ((Context)this.contextProvider.get()).graphQLTypeRegistry.addEnumTypeIfNotAlreadyPresent(clazz, SchemaType.RICH);
        }
        return this.scalarMapper.scalarTypeFor(clazz);
    }

    @Override
    public Object unmarshal(Object gqlValue, ObjectSpecification targetObjectSpec) {
        Class correspondingClass = targetObjectSpec.getCorrespondingClass();
        if (correspondingClass.isEnum()) {
            return gqlValue;
        }
        return this.scalarMapper.unmarshal(gqlValue, correspondingClass);
    }

    @Override
    public GraphQLOutputType outputTypeFor(OneToOneFeature oneToOneFeature, SchemaType schemaType) {
        ObjectSpecification otoaObjectSpec = oneToOneFeature.getElementType();
        return switch (otoaObjectSpec.getBeanSort()) {
            case BeanSort.VIEW_MODEL, BeanSort.ENTITY -> TypeMapperDefault.typeRefPossiblyOptional(oneToOneFeature, schemaType, otoaObjectSpec);
            case BeanSort.VALUE -> this.scalarTypePossiblyOptional(oneToOneFeature, otoaObjectSpec);
            default -> null;
        };
    }

    private static GraphQLOutputType typeRefPossiblyOptional(OneToOneFeature oneToOneFeature, SchemaType schemaType, ObjectSpecification otoaObjectSpec) {
        GraphQLTypeReference fieldTypeRef = GraphQLTypeReference.typeRef((String)TypeNames.objectTypeNameFor(otoaObjectSpec, schemaType));
        return oneToOneFeature.isOptional() ? fieldTypeRef : GraphQLNonNull.nonNull((GraphQLType)fieldTypeRef);
    }

    private GraphQLOutputType scalarTypePossiblyOptional(OneToOneFeature oneToOneFeature, ObjectSpecification otoaObjectSpec) {
        GraphQLOutputType scalarType = this.outputTypeFor(otoaObjectSpec.getCorrespondingClass());
        return oneToOneFeature.isOptional() ? scalarType : GraphQLNonNull.nonNull((GraphQLType)scalarType);
    }

    @Override
    public @Nullable GraphQLOutputType outputTypeFor(ObjectSpecification objectSpecification, SchemaType schemaType) {
        return switch (objectSpecification.getBeanSort()) {
            case BeanSort.VIEW_MODEL, BeanSort.ENTITY, BeanSort.ABSTRACT -> GraphQLTypeReference.typeRef((String)TypeNames.objectTypeNameFor(objectSpecification, schemaType));
            case BeanSort.VALUE -> this.outputTypeFor(objectSpecification.getCorrespondingClass());
            case BeanSort.COLLECTION -> null;
            default -> Scalars.GraphQLString;
        };
    }

    @Override
    public @Nullable GraphQLList listTypeForElementTypeOf(OneToManyAssociation oneToManyAssociation, SchemaType schemaType) {
        ObjectSpecification elementType = oneToManyAssociation.getElementType();
        return this.listTypeFor(elementType, schemaType);
    }

    @Override
    public @Nullable GraphQLList listTypeFor(ObjectSpecification elementType, SchemaType schemaType) {
        return switch (elementType.getBeanSort()) {
            case BeanSort.VIEW_MODEL, BeanSort.ENTITY -> GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)TypeNames.objectTypeNameFor(elementType, schemaType)));
            case BeanSort.VALUE -> GraphQLList.list((GraphQLType)this.outputTypeFor(elementType.getCorrespondingClass()));
            default -> null;
        };
    }

    @Override
    public GraphQLInputType inputTypeFor(OneToOneFeature oneToOneFeature, TypeMapper.InputContext inputContext, SchemaType schemaType) {
        return oneToOneFeature.isOptional() || inputContext.isOptionalAlwaysAllowed() ? this.inputTypeFor_(oneToOneFeature, schemaType) : GraphQLNonNull.nonNull((GraphQLType)this.inputTypeFor_(oneToOneFeature, schemaType));
    }

    private GraphQLInputType inputTypeFor_(OneToOneFeature oneToOneFeature, SchemaType schemaType) {
        ObjectSpecification elementObjectSpec = oneToOneFeature.getElementType();
        Class elementClass = elementObjectSpec.getCorrespondingClass();
        if (elementClass.isInterface()) {
            return this.inputTypeFor(elementClass);
        }
        return switch (elementObjectSpec.getBeanSort()) {
            case BeanSort.VIEW_MODEL, BeanSort.ENTITY, BeanSort.ABSTRACT -> GraphQLTypeReference.typeRef((String)TypeNames.inputTypeNameFor(elementObjectSpec, schemaType));
            case BeanSort.VALUE -> this.inputTypeFor(elementObjectSpec.getCorrespondingClass());
            case BeanSort.COLLECTION -> throw new IllegalArgumentException(String.format("OneToOneFeature '%s' is not expected to have a beanSort of COLLECTION", oneToOneFeature.getFeatureIdentifier().toString()));
            default -> Scalars.GraphQLString;
        };
    }

    @Override
    public GraphQLList inputTypeFor(OneToManyActionParameter oneToManyActionParameter, SchemaType schemaType) {
        ObjectSpecification elementObjectSpec = oneToManyActionParameter.getElementType();
        return GraphQLList.list((GraphQLType)this.inputTypeFor(elementObjectSpec, schemaType));
    }

    @Override
    public GraphQLInputType inputTypeFor(ObjectSpecification elementType, SchemaType schemaType) {
        return switch (elementType.getBeanSort()) {
            case BeanSort.VIEW_MODEL, BeanSort.ENTITY, BeanSort.ABSTRACT -> GraphQLTypeReference.typeRef((String)TypeNames.inputTypeNameFor(elementType, schemaType));
            case BeanSort.VALUE -> this.inputTypeFor(elementType.getCorrespondingClass());
            case BeanSort.COLLECTION -> throw new IllegalArgumentException(String.format("ObjectSpec '%s' is not expected to have a beanSort of COLLECTION", elementType.getFullIdentifier()));
            default -> Scalars.GraphQLString;
        };
    }

    @Inject
    @Generated
    public TypeMapperDefault(ScalarMapper scalarMapper, Provider<Context> contextProvider) {
        this.scalarMapper = scalarMapper;
        this.contextProvider = contextProvider;
    }

    @Configuration
    public static class AutoConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={TypeMapper.class})
        public TypeMapper defaultTypeMapper(ScalarMapper scalarMapper, Provider<Context> contextProvider) {
            return new TypeMapperDefault(scalarMapper, contextProvider);
        }
    }
}

