/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.viewer.controller;

import jakarta.inject.Inject;
import java.util.Objects;
import java.util.Optional;
import org.apache.causeway.applib.layout.grid.Grid;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.applib.value.Clob;
import org.apache.causeway.commons.io.JaxbUtils;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.facets.object.grid.GridFacet;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.objectmanager.ObjectManager;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/graphql/object"})
public class ResourceController {
    private final BookmarkService bookmarkService;
    private final ObjectManager objectManager;
    private final CausewayConfiguration.Viewer.Graphql graphqlConfiguration;

    @Inject
    public ResourceController(BookmarkService bookmarkService, ObjectManager objectManager, CausewayConfiguration causewayConfiguration) {
        this.bookmarkService = bookmarkService;
        this.objectManager = objectManager;
        this.graphqlConfiguration = causewayConfiguration.getViewer().getGraphql();
    }

    @GetMapping(value={"/{logicalTypeName}:{id}/{propertyId}/blobBytes"})
    public ResponseEntity<byte[]> propertyBlobBytes(@PathVariable String logicalTypeName, @PathVariable String id, @PathVariable String propertyId) {
        CausewayConfiguration.Viewer.Graphql.ResponseType responseType = this.graphqlConfiguration.getResources().getResponseType();
        if (responseType == CausewayConfiguration.Viewer.Graphql.ResponseType.FORBIDDEN) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        return this.valueOfProperty(logicalTypeName, id, propertyId).filter(Blob.class::isInstance).map(Blob.class::cast).map(blob -> {
            ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok().contentType(MediaType.asMediaType((MimeType)MimeType.valueOf((String)blob.getMimeType().toString())));
            if (responseType == CausewayConfiguration.Viewer.Graphql.ResponseType.ATTACHMENT) {
                ((ResponseEntity.BodyBuilder)bodyBuilder.header("Content-Disposition", new String[]{ContentDisposition.attachment().filename(blob.getName()).build().toString()})).contentLength((long)blob.getBytes().length);
            }
            return bodyBuilder.body((Object)blob.getBytes());
        }).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{logicalTypeName}:{id}/{propertyId}/clobChars"})
    public ResponseEntity<CharSequence> propertyClobChars(@PathVariable String logicalTypeName, @PathVariable String id, @PathVariable String propertyId) {
        CausewayConfiguration.Viewer.Graphql.ResponseType responseType = this.graphqlConfiguration.getResources().getResponseType();
        if (responseType == CausewayConfiguration.Viewer.Graphql.ResponseType.FORBIDDEN) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        return this.valueOfProperty(logicalTypeName, id, propertyId).filter(Clob.class::isInstance).map(Clob.class::cast).map(clob -> {
            ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok().contentType(MediaType.asMediaType((MimeType)MimeType.valueOf((String)clob.getMimeType().toString())));
            if (responseType == CausewayConfiguration.Viewer.Graphql.ResponseType.ATTACHMENT) {
                ((ResponseEntity.BodyBuilder)bodyBuilder.header("Content-Disposition", new String[]{ContentDisposition.attachment().filename(clob.getName()).build().toString()})).contentLength((long)clob.getChars().length());
            }
            return bodyBuilder.body((Object)clob.getChars());
        }).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{logicalTypeName}:{id}/{_meta}/grid"})
    public ResponseEntity<String> grid(@PathVariable String logicalTypeName, @PathVariable String id, @PathVariable String _meta) {
        CausewayConfiguration.Viewer.Graphql.ResponseType responseType = this.graphqlConfiguration.getResources().getResponseType();
        if (responseType == CausewayConfiguration.Viewer.Graphql.ResponseType.FORBIDDEN) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        if (!_meta.equals(this.graphqlConfiguration.getMetaData().getFieldName())) {
            return ResponseEntity.notFound().build();
        }
        return this.lookup(logicalTypeName, id).map(ResourceController::gridOf).filter(Objects::nonNull).map(x$0 -> JaxbUtils.toStringUtf8((Object)x$0, (JaxbUtils.JaxbCustomizer[])new JaxbUtils.JaxbCustomizer[0])).map(x -> x.replaceAll("(\r\n)", "\n")).map(gridText -> {
            ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok().contentType(MediaType.APPLICATION_XML);
            if (responseType == CausewayConfiguration.Viewer.Graphql.ResponseType.ATTACHMENT) {
                ((ResponseEntity.BodyBuilder)bodyBuilder.header("Content-Disposition", new String[]{ContentDisposition.attachment().filename(logicalTypeName + ".layout.xml").build().toString()})).contentLength((long)gridText.length());
            }
            return bodyBuilder.body(gridText);
        }).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{logicalTypeName}:{id}/{_meta}/icon"})
    public ResponseEntity<byte[]> icon(@PathVariable String logicalTypeName, @PathVariable String id, @PathVariable String _meta) {
        CausewayConfiguration.Viewer.Graphql.ResponseType responseType = this.graphqlConfiguration.getResources().getResponseType();
        if (responseType == CausewayConfiguration.Viewer.Graphql.ResponseType.FORBIDDEN) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        if (!_meta.equals(this.graphqlConfiguration.getMetaData().getFieldName())) {
            return ResponseEntity.notFound().build();
        }
        return this.lookup(logicalTypeName, id).map(ManagedObject::getIcon).filter(Objects::nonNull).map(objectIcon -> {
            byte[] bytes = objectIcon.asBytes();
            ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok().contentType(MediaType.parseMediaType((String)objectIcon.getMimeType().getMimeType().toString()));
            if (responseType == CausewayConfiguration.Viewer.Graphql.ResponseType.ATTACHMENT) {
                ((ResponseEntity.BodyBuilder)bodyBuilder.header("Content-Disposition", new String[]{ContentDisposition.attachment().filename(logicalTypeName + ".png").build().toString()})).contentLength((long)bytes.length);
            }
            return bodyBuilder.body((Object)bytes);
        }).orElse(ResponseEntity.notFound().build());
    }

    @Nullable
    private static Grid gridOf(ManagedObject managedObject) {
        GridFacet facet = (GridFacet)managedObject.getSpecification().getFacet(GridFacet.class);
        return facet != null ? facet.getGrid(managedObject) : null;
    }

    private Optional<Object> valueOfProperty(String logicalTypeName, String id, String propertyId) {
        return this.lookup(logicalTypeName, id).map(managedObject -> ManagedObjectAndPropertyIfAny.of(managedObject, managedObject.getSpecification().getProperty(propertyId))).filter(ManagedObjectAndPropertyIfAny::isPropertyPresent).map(ManagedObjectAndProperty::of).map(ManagedObjectAndProperty::value).map(ManagedObject::getPojo);
    }

    private Optional<ManagedObject> lookup(String logicalTypeName, String id) {
        return this.bookmarkService.lookup(Bookmark.forLogicalTypeNameAndIdentifier((String)logicalTypeName, (String)id)).map(arg_0 -> ((ObjectManager)this.objectManager).adapt(arg_0));
    }

    private static final class ManagedObjectAndPropertyIfAny {
        private final ManagedObject owningObject;
        private final Optional<OneToOneAssociation> propertyIfAny;

        boolean isPropertyPresent() {
            return this.propertyIfAny.isPresent();
        }

        private ManagedObjectAndPropertyIfAny(ManagedObject owningObject, Optional<OneToOneAssociation> propertyIfAny) {
            this.owningObject = owningObject;
            this.propertyIfAny = propertyIfAny;
        }

        public static ManagedObjectAndPropertyIfAny of(ManagedObject owningObject, Optional<OneToOneAssociation> propertyIfAny) {
            return new ManagedObjectAndPropertyIfAny(owningObject, propertyIfAny);
        }

        public ManagedObject getOwningObject() {
            return this.owningObject;
        }

        public Optional<OneToOneAssociation> getPropertyIfAny() {
            return this.propertyIfAny;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManagedObjectAndPropertyIfAny)) {
                return false;
            }
            ManagedObjectAndPropertyIfAny other = (ManagedObjectAndPropertyIfAny)o;
            ManagedObject this$owningObject = this.getOwningObject();
            ManagedObject other$owningObject = other.getOwningObject();
            if (this$owningObject == null ? other$owningObject != null : !this$owningObject.equals(other$owningObject)) {
                return false;
            }
            Optional<OneToOneAssociation> this$propertyIfAny = this.getPropertyIfAny();
            Optional<OneToOneAssociation> other$propertyIfAny = other.getPropertyIfAny();
            return !(this$propertyIfAny == null ? other$propertyIfAny != null : !((Object)this$propertyIfAny).equals(other$propertyIfAny));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ManagedObject $owningObject = this.getOwningObject();
            result = result * 59 + ($owningObject == null ? 43 : $owningObject.hashCode());
            Optional<OneToOneAssociation> $propertyIfAny = this.getPropertyIfAny();
            result = result * 59 + ($propertyIfAny == null ? 43 : ((Object)$propertyIfAny).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceController.ManagedObjectAndPropertyIfAny(owningObject=" + this.getOwningObject() + ", propertyIfAny=" + this.getPropertyIfAny() + ")";
        }
    }

    private static class ManagedObjectAndProperty {
        ManagedObject owningObject;
        OneToOneAssociation property;

        private static ManagedObjectAndProperty of(ManagedObjectAndPropertyIfAny tuple) {
            return new ManagedObjectAndProperty(tuple);
        }

        private ManagedObjectAndProperty(ManagedObjectAndPropertyIfAny tuple) {
            this.owningObject = tuple.owningObject;
            this.property = tuple.propertyIfAny.orElse(null);
        }

        ManagedObject value() {
            return this.property.get(this.owningObject);
        }
    }
}

