/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.viewer.integration;

import graphql.GraphQL;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import jakarta.annotation.PostConstruct;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.config.environment.CausewaySystemEnvironment;
import org.apache.causeway.core.config.metamodel.specloader.IntrospectionMode;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.rich.mutation.RichTopLevelMutation;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichTopLevelQuery;
import org.apache.causeway.viewer.graphql.model.domain.simple.mutation.SimpleTopLevelMutation;
import org.apache.causeway.viewer.graphql.model.domain.simple.query.SimpleTopLevelQuery;
import org.apache.causeway.viewer.graphql.model.registry.GraphQLTypeRegistry;
import org.apache.causeway.viewer.graphql.model.toplevel.BothTopLevelQuery;
import org.apache.causeway.viewer.graphql.viewer.integration.AsyncExecutionStrategyResolvingWithinInteraction;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.stereotype.Service;

@Service
public class GraphQlSourceForCauseway
implements GraphQlSource {
    private final CausewayConfiguration causewayConfiguration;
    private final CausewaySystemEnvironment causewaySystemEnvironment;
    private final SpecificationLoader specificationLoader;
    private final GraphQLTypeRegistry graphQLTypeRegistry;
    private final Context context;
    private final AsyncExecutionStrategyResolvingWithinInteraction executionStrategy;
    private CausewayConfiguration.Viewer.Graphql graphqlConfiguration;
    GraphQL graphQL;

    public GraphQlSourceForCauseway(CausewayConfiguration causewayConfiguration, CausewaySystemEnvironment causewaySystemEnvironment, SpecificationLoader specificationLoader, GraphQLTypeRegistry graphQLTypeRegistry, Context context, AsyncExecutionStrategyResolvingWithinInteraction executionStrategy) {
        this.causewayConfiguration = causewayConfiguration;
        this.causewaySystemEnvironment = causewaySystemEnvironment;
        this.specificationLoader = specificationLoader;
        this.graphQLTypeRegistry = graphQLTypeRegistry;
        this.context = context;
        this.executionStrategy = executionStrategy;
        this.graphqlConfiguration = causewayConfiguration.getViewer().getGraphql();
    }

    @PostConstruct
    public void init() {
        boolean fullyIntrospect = IntrospectionMode.isFullIntrospect((CausewayConfiguration)this.causewayConfiguration, (CausewaySystemEnvironment)this.causewaySystemEnvironment);
        if (!fullyIntrospect) {
            throw new IllegalStateException("GraphQL requires full introspection mode");
        }
    }

    public GraphQL graphQl() {
        if (this.graphQL == null) {
            this.graphQL = GraphQL.newGraphQL((GraphQLSchema)this.schema()).defaultDataFetcherExceptionHandler((DataFetcherExceptionHandler)new SimpleDataFetcherExceptionHandler()).queryExecutionStrategy((ExecutionStrategy)this.executionStrategy).mutationExecutionStrategy((ExecutionStrategy)this.executionStrategy).build();
        }
        return this.graphQL;
    }

    public GraphQLSchema schema() {
        boolean fullyIntrospected = this.specificationLoader.isMetamodelFullyIntrospected();
        if (!fullyIntrospected) {
            throw new IllegalStateException("Metamodel is not fully introspected");
        }
        ElementCustom topLevelQuery = this.determineTopLevelQueryFrom(this.graphqlConfiguration.getSchemaStyle());
        ElementCustom topLevelMutation = this.determineTopLevelMutationFrom(this.graphqlConfiguration.getSchemaStyle());
        topLevelQuery.addDataFetchers();
        topLevelMutation.addDataFetchers();
        GraphQLCodeRegistry codeRegistry = this.context.codeRegistryBuilder.build();
        return GraphQLSchema.newSchema().query(topLevelQuery.getGqlObjectType()).mutation(topLevelMutation.getGqlObjectType()).additionalTypes(this.graphQLTypeRegistry.getGraphQLTypes()).additionalType((GraphQLType)this.context.getLogicalTypeNames()).codeRegistry(codeRegistry).build();
    }

    private ElementCustom determineTopLevelQueryFrom(CausewayConfiguration.Viewer.Graphql.SchemaStyle schemaStyle) {
        switch (schemaStyle) {
            case SIMPLE_ONLY: {
                return new SimpleTopLevelQuery(this.context);
            }
            case RICH_ONLY: {
                return new RichTopLevelQuery(this.context);
            }
            case SIMPLE_AND_RICH: 
            case RICH_AND_SIMPLE: {
                return new BothTopLevelQuery(this.context);
            }
        }
        throw new IllegalStateException(String.format("Configured SchemaStyle '%s' not recognised", schemaStyle));
    }

    private ElementCustom determineTopLevelMutationFrom(CausewayConfiguration.Viewer.Graphql.SchemaStyle schemaStyle) {
        switch (schemaStyle) {
            case SIMPLE_ONLY: {
                return new SimpleTopLevelMutation(this.context);
            }
            case RICH_ONLY: {
                return new RichTopLevelMutation(this.context);
            }
            case SIMPLE_AND_RICH: {
                return new SimpleTopLevelMutation(this.context);
            }
            case RICH_AND_SIMPLE: {
                return new RichTopLevelMutation(this.context);
            }
        }
        throw new IllegalStateException(String.format("Configured SchemaStyle '%s' not recognised", schemaStyle));
    }
}

