/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.applib.dtos;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsProvider;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.schema.common.v2.ValueType;

@JsonIgnoreProperties(value={"links", "extensions"})
public final class ScalarValueDtoV2 {
    private String type;
    private Object value;
    private static String VALUE_DECOMPOSITION_TYPE_NAME = "ValueDecomposition[base64/zlib]";

    public static ScalarValueDtoV2 forNull(@NonNull Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return new ScalarValueDtoV2(ScalarValueDtoV2.typeName(type), null);
    }

    public static ScalarValueDtoV2 forValue(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new ScalarValueDtoV2(ScalarValueDtoV2.typeName(value.getClass()), value);
    }

    public static <T> ScalarValueDtoV2 forValue(@NonNull T value, @NonNull ValueSemanticsProvider<T> valueSemantics) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (valueSemantics == null) {
            throw new NullPointerException("valueSemantics is marked non-null but is null");
        }
        ValueDecomposition valDecomp = valueSemantics.decompose(value);
        return new ScalarValueDtoV2(VALUE_DECOMPOSITION_TYPE_NAME, valDecomp.stringify());
    }

    @JsonIgnore
    public boolean isNull() {
        return this.value == null;
    }

    @JsonIgnore
    public boolean isValueDecomposition() {
        return VALUE_DECOMPOSITION_TYPE_NAME.equals(this.getType());
    }

    @JsonIgnore
    public <T> T getValueAs(Class<T> entityType) {
        if (this.isValueDecomposition() && this.value instanceof String) {
            try {
                String stringifiedComposite = (String)this.getValue();
                this.value = ValueDecomposition.destringify((ValueType)ValueType.COMPOSITE, (String)stringifiedComposite);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return (T)_Casts.uncheckedCast((Object)this.getValue());
    }

    private static String typeName(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return cls.isPrimitive() || cls.getPackageName().startsWith("java.") ? cls.getSimpleName() : cls.getName();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setValue(Object value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScalarValueDtoV2)) {
            return false;
        }
        ScalarValueDtoV2 other = (ScalarValueDtoV2)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScalarValueDtoV2(type=" + this.getType() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public ScalarValueDtoV2() {
    }

    @Generated
    private ScalarValueDtoV2(String type, Object value) {
        this.type = type;
        this.value = value;
    }
}

