/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.jaxrsresteasy.webmodule;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.causeway.applib.services.inject.ServiceInjector;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.config.RestEasyConfiguration;
import org.apache.causeway.core.webapp.modules.WebModuleAbstract;
import org.apache.causeway.core.webapp.modules.WebModuleContext;
import org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayRestfulObjectsInteractionFilter;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.ro.WebModuleJaxrsRestEasy")
@Priority(value=0x3FFFFFAF)
@Qualifier(value="JaxrsRestEasy")
public final class WebModuleJaxrsResteasy
extends WebModuleAbstract {
    private static final String INTERACTION_FILTER_NAME = "CausewayRestfulObjectsInteractionFilter";
    private final CausewayConfiguration causewayConfiguration;
    private final RestEasyConfiguration restEasyConfiguration;
    private final String restfulPath;
    private final String urlPattern;
    private final String name = "JaxrsRestEasy";

    @Inject
    public WebModuleJaxrsResteasy(CausewayConfiguration causewayConfiguration, RestEasyConfiguration restEasyConfiguration, ServiceInjector serviceInjector) {
        super(serviceInjector);
        this.causewayConfiguration = causewayConfiguration;
        this.restEasyConfiguration = restEasyConfiguration;
        this.restfulPath = this.restEasyConfiguration.getJaxrs().getDefaultPath() + "/";
        this.urlPattern = this.restfulPath + "*";
    }

    public void prepare(WebModuleContext ctx) {
        ResteasyProviderFactory.setInstance((ResteasyProviderFactory)new ResteasyProviderFactoryImpl());
        super.prepare(ctx);
        if (!this.isApplicable(ctx)) {
            return;
        }
        ctx.addProtectedPath(this.urlPattern);
    }

    public Can<ServletContextListener> init(ServletContext ctx) throws ServletException {
        String authenticationStrategyClassName = this.causewayConfiguration.getViewer().getRestfulobjects().getAuthentication().getStrategyClassName();
        this.registerFilter(ctx, INTERACTION_FILTER_NAME, CausewayRestfulObjectsInteractionFilter.class).ifPresent(filterReg -> {
            filterReg.addMappingForUrlPatterns(null, true, new String[]{this.urlPattern});
            filterReg.setInitParameter("authenticationStrategy", authenticationStrategyClassName);
            filterReg.setInitParameter("whenNoSession", "auto");
            filterReg.setInitParameter("passThru", String.join((CharSequence)",", this.restfulPath + "swagger", this.restfulPath + "health"));
        });
        return Can.empty();
    }

    public String getName() {
        return this.name;
    }
}

