/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering;

import javax.ws.rs.core.MediaType;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulHttpMethod;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;

public final class LinkBuilder {
    private final IResourceContext resourceContext;
    private final JsonRepresentation representation = JsonRepresentation.newMap((String[])new String[0]);
    private final String rel;
    private final String href;
    private final MediaType mediaType;
    private RestfulHttpMethod method = RestfulHttpMethod.GET;
    private String title;
    private JsonRepresentation arguments;
    private JsonRepresentation value;

    public static LinkBuilder newBuilder(IResourceContext resourceContext, String rel, RepresentationType representationType, String hrefFormat, Object ... hrefArgs) {
        return LinkBuilder.newBuilder(resourceContext, rel, representationType.getJsonElseXmlMediaType(), hrefFormat, hrefArgs);
    }

    public static LinkBuilder newBuilder(IResourceContext resourceContext, String rel, MediaType mediaType, String hrefFormat, Object ... hrefArgs) {
        return new LinkBuilder(resourceContext, rel, String.format(hrefFormat, hrefArgs), mediaType);
    }

    protected LinkBuilder(IResourceContext resourceContext, String rel, String href, MediaType mediaType) {
        this.resourceContext = resourceContext;
        this.rel = rel;
        this.href = href;
        this.mediaType = mediaType;
    }

    public LinkBuilder withHttpMethod(RestfulHttpMethod method) {
        this.method = method;
        return this;
    }

    public LinkBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public LinkBuilder withArguments(JsonRepresentation arguments) {
        this.arguments = arguments;
        return this;
    }

    public LinkBuilder withValue(JsonRepresentation value) {
        this.value = value;
        return this;
    }

    public JsonRepresentation build() {
        this.representation.mapPutString("rel", this.rel);
        this.representation.mapPutString("href", this.resourceContext.restfulUrlFor(this.href));
        this.representation.mapPut("method", (Object)this.method);
        this.representation.mapPutString("type", this.mediaType.toString());
        this.representation.mapPutString("title", this.title);
        this.representation.mapPutJsonRepresentation("arguments", this.arguments);
        this.representation.mapPutJsonRepresentation("value", this.value);
        return this.representation;
    }

    public JsonRepresentation buildAsApplicationResource() {
        this.build();
        this.representation.mapPutString("href", this.resourceContext.applicationUrlFor(this.href));
        return this.representation;
    }
}

