/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.causeway.applib.services.swagger.Visibility;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.spec.ActionScope;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.ClassExcluder;

final class _Util {
    static boolean isVisibleForPublic(ObjectAction objectAction) {
        ObjectSpecification specification = objectAction.getReturnType();
        return (_Util.isVisibleForPublic(specification) || _Util.isTypeOfVisibleForPublic(objectAction)) && _Util.isVisibleForPublic((Can<ObjectSpecification>)objectAction.getParameterTypes());
    }

    private static boolean isTypeOfVisibleForPublic(ObjectAction objectAction) {
        return _Util.isVisibleForPublic(objectAction.getElementType());
    }

    private static boolean isVisibleForPublic(Can<ObjectSpecification> parameterTypes) {
        boolean atLeastOneParamNotVisible = parameterTypes.stream().map(_Util::isNotVisibleForPublic).findAny().isPresent();
        return !atLeastOneParamNotVisible;
    }

    static boolean isVisibleForPublic(ObjectAssociation objectAssociation) {
        ObjectSpecification specification = objectAssociation.getElementType();
        return _Util.isVisibleForPublic(specification);
    }

    static boolean isNotVisibleForPublic(ObjectSpecification specification) {
        return !_Util.isVisibleForPublic(specification);
    }

    static boolean isVisibleForPublic(ObjectSpecification specification) {
        ObjectSpecification elementSpec;
        if (specification == null) {
            return true;
        }
        if (specification.isViewModel()) {
            return true;
        }
        if (specification.isValue()) {
            return true;
        }
        if (specification.isPlural() && (elementSpec = (ObjectSpecification)Facets.elementSpec((FacetHolder)specification).orElse(null)) != null) {
            return _Util.isVisibleForPublic(elementSpec);
        }
        Class correspondingClass = specification.getCorrespondingClass();
        return Collection.class.isAssignableFrom(correspondingClass) || correspondingClass.isArray() || correspondingClass == Void.TYPE || correspondingClass == Void.class;
    }

    static Predicate<ObjectAssociation> associationsWith(Visibility visibility) {
        return objectAssociation -> !visibility.isPublic() || _Util.isVisibleForPublic(objectAssociation);
    }

    static List<OneToOneAssociation> propertiesOf(ObjectSpecification objectSpecification, Visibility visibility) {
        return _Util.associationsOf(objectSpecification, ObjectAssociation.Predicates.PROPERTIES, visibility);
    }

    static List<OneToManyAssociation> collectionsOf(ObjectSpecification objectSpecification, Visibility visibility) {
        return _Util.associationsOf(objectSpecification, ObjectAssociation.Predicates.COLLECTIONS, visibility);
    }

    private static <T extends ObjectAssociation> List<T> associationsOf(ObjectSpecification objectSpecification, Predicate<ObjectAssociation> associationPredicate, Visibility visibility) {
        return objectSpecification.streamAssociations(MixedIn.INCLUDED).filter(associationPredicate.and(_Util.associationsWith(visibility))).map(x -> (ObjectAssociation)_Casts.uncheckedCast((Object)x)).collect(Collectors.toList());
    }

    static List<ObjectAction> actionsOf(ObjectSpecification objectSpec, Visibility visibility, ClassExcluder classExcluder) {
        ImmutableEnumSet<ActionScope> actionTypes = _Util.actionScopesFor(visibility);
        return objectSpec.streamActions(actionTypes, MixedIn.INCLUDED).filter(objectAction -> !classExcluder.exclude((ObjectAction)objectAction) && !visibility.isPublic() || _Util.isVisibleForPublic(objectAction)).collect(Collectors.toList());
    }

    static ImmutableEnumSet<ActionScope> actionScopesFor(Visibility visibility) {
        switch (visibility) {
            case PUBLIC: 
            case PRIVATE: {
                return ActionScope.PRODUCTION_ONLY;
            }
            case PRIVATE_WITH_PROTOTYPING: {
                return ActionScope.ANY;
            }
        }
        throw _Exceptions.unmatchedCase((Object)visibility);
    }

    private _Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

