/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.valuerender;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.rendering.service.valuerender.JsonValueConverter;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

final class _JsonValueConverters {
    _JsonValueConverters() {
    }

    public static Map<Class<?>, JsonValueConverter> byClass() {
        LinkedHashMap converterByClass = _Maps.newLinkedHashMap();
        new _JsonValueConverters().asList().forEach(converter -> converterByClass.put(converter.getValueClass(), converter));
        return converterByClass;
    }

    private List<JsonValueConverter> asList() {
        ArrayList converters = _Lists.newArrayList();
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.STRING){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isString()) {
                    return repr.asString();
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 1.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof String) {
                    repr.mapPutString("value", (String)obj);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.BOOLEAN){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isBoolean()) {
                    return repr.asBoolean();
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 2.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Boolean) {
                    repr.mapPutBooleanNullable("value", (Boolean)obj);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.BYTE){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isNumber()) {
                    return repr.asNumber().byteValue();
                }
                if (repr.isInt()) {
                    return (byte)repr.asInt().intValue();
                }
                if (repr.isLong()) {
                    return (byte)repr.asLong().longValue();
                }
                if (repr.isBigInteger()) {
                    return repr.asBigInteger().byteValue();
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 3.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Byte) {
                    repr.mapPutByteNullable("value", (Byte)obj);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.SHORT){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isNumber()) {
                    return repr.asNumber().shortValue();
                }
                if (repr.isInt()) {
                    return (short)repr.asInt().intValue();
                }
                if (repr.isLong()) {
                    return (short)repr.asLong().longValue();
                }
                if (repr.isBigInteger()) {
                    return repr.asBigInteger().shortValue();
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 4.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Short) {
                    repr.mapPutShortNullable("value", (Short)obj);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.INT){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isInt()) {
                    return repr.asInt();
                }
                if (repr.isLong()) {
                    return repr.asLong().intValue();
                }
                if (repr.isBigInteger()) {
                    return repr.asBigInteger().intValue();
                }
                if (repr.isNumber()) {
                    return repr.asNumber().intValue();
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 5.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Integer) {
                    repr.mapPutIntNullable("value", (Integer)obj);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.LONG){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isLong()) {
                    return repr.asLong();
                }
                if (repr.isInt()) {
                    return repr.asLong();
                }
                if (repr.isBigInteger()) {
                    return repr.asBigInteger().longValue();
                }
                if (repr.isNumber()) {
                    return repr.asNumber().longValue();
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 6.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Long) {
                    Long l = (Long)obj;
                    repr.mapPutLongNullable("value", l);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.FLOAT){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isDecimal()) {
                    return Float.valueOf(repr.asDouble().floatValue());
                }
                if (repr.isNumber()) {
                    return Float.valueOf(repr.asNumber().floatValue());
                }
                if (repr.isLong()) {
                    return Float.valueOf(repr.asLong().floatValue());
                }
                if (repr.isInt()) {
                    return Float.valueOf(repr.asInt().floatValue());
                }
                if (repr.isBigInteger()) {
                    return Float.valueOf(repr.asBigInteger().floatValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 7.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Float) {
                    Float f = (Float)obj;
                    repr.mapPutFloatNullable("value", f);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.DOUBLE){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isDecimal()) {
                    return repr.asDouble();
                }
                if (repr.isLong()) {
                    return repr.asLong().doubleValue();
                }
                if (repr.isInt()) {
                    return repr.asInt().doubleValue();
                }
                if (repr.isBigInteger()) {
                    return repr.asBigInteger().doubleValue();
                }
                if (repr.isBigDecimal()) {
                    return repr.asBigDecimal().doubleValue();
                }
                if (repr.isNumber()) {
                    return repr.asNumber().doubleValue();
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 8.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Double) {
                    Double d = (Double)obj;
                    repr.mapPutDoubleNullable("value", d);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.CHAR){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                Integer x;
                String str;
                if (repr.isString() && (str = repr.asString()) != null && str.length() > 0) {
                    return Character.valueOf(str.charAt(0));
                }
                if (repr.isInt() && 0 <= (x = repr.asInt()) && x <= 65535) {
                    char c = (char)x.intValue();
                    return Character.valueOf(c);
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 9.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Character) {
                    Character c = (Character)obj;
                    repr.mapPutCharNullable("value", c);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.BIGINTEGER){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isString()) {
                    return new BigInteger(repr.asString());
                }
                if (repr.isBigInteger()) {
                    return repr.asBigInteger(this.format);
                }
                if (repr.isLong()) {
                    return BigInteger.valueOf(repr.asLong());
                }
                if (repr.isInt()) {
                    return BigInteger.valueOf(repr.asInt().intValue());
                }
                if (repr.isNumber()) {
                    return BigInteger.valueOf(repr.asNumber().longValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 10.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof BigInteger) {
                    BigInteger bi = (BigInteger)obj;
                    repr.mapPutBigInteger("value", bi);
                    context.maxTotalDigits(objectAdapter).ifPresentOrElse(totalDigits -> repr.putFormat(String.format("big-integer(%d)", totalDigits)), () -> repr.putFormat(this.format));
                } else {
                    repr.mapPut("value", obj);
                    repr.putFormat(this.format);
                }
                if (!context.isSuppressExtensions()) {
                    repr.putExtendedFormat(this.extendedFormat);
                }
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.BIGDECIMAL){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isString()) {
                    return new BigDecimal(repr.asString());
                }
                if (repr.isBigDecimal()) {
                    return repr.asBigDecimal(this.format);
                }
                if (repr.isBigInteger()) {
                    return new BigDecimal(repr.asBigInteger());
                }
                if (repr.isDecimal()) {
                    return BigDecimal.valueOf(repr.asDouble());
                }
                if (repr.isLong()) {
                    return BigDecimal.valueOf(repr.asLong());
                }
                if (repr.isInt()) {
                    return BigDecimal.valueOf(repr.asInt().intValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 11.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof BigDecimal) {
                    BigDecimal bd = (BigDecimal)obj;
                    repr.mapPutBigDecimal("value", bd);
                    int totalDigits = context.maxTotalDigits(objectAdapter).orElse(-1);
                    int scale = context.maxFractionalDigits(objectAdapter).orElse(-1);
                    if (totalDigits > -1 && scale > -1) {
                        String formatOverride = String.format("big-decimal(%d,%d)", totalDigits, scale);
                        repr.putFormat(formatOverride);
                    } else {
                        repr.putFormat(this.format);
                    }
                } else {
                    repr.mapPut("value", obj);
                    repr.putFormat(this.format);
                }
                if (!context.isSuppressExtensions()) {
                    repr.putExtendedFormat(this.extendedFormat);
                }
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.JODALOCALDATE){
            final List<DateTimeFormatter> formatters;
            {
                this.formatters = Arrays.asList(ISODateTimeFormat.date(), ISODateTimeFormat.basicDate(), DateTimeFormat.forPattern((String)"yyyyMMdd"), JsonRepresentation.yyyyMMdd);
            }

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            LocalDate parsedDate = formatter.parseLocalDate(dateStr);
                            return parsedDate;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 12.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof LocalDate) {
                    LocalDate date = (LocalDate)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)date.toDateTimeAtStartOfDay());
                    repr.mapPutString("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.JODALOCALDATETIME){
            final List<DateTimeFormatter> formatters;
            {
                this.formatters = Arrays.asList(ISODateTimeFormat.dateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.dateTime().withZoneUTC(), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicDateTime().withZoneUTC(), JsonRepresentation.yyyyMMddTHHmmssZ.withZoneUTC());
            }

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            LocalDateTime parsedDate = formatter.parseLocalDateTime(dateStr);
                            return parsedDate;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 13.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof LocalDateTime) {
                    LocalDateTime date = (LocalDateTime)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)date.toDateTime());
                    repr.mapPutString("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.JODADATETIME){
            final List<DateTimeFormatter> formatters;
            {
                this.formatters = Arrays.asList(ISODateTimeFormat.dateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.dateTime().withZoneUTC(), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicDateTime().withZoneUTC(), JsonRepresentation.yyyyMMddTHHmmssZ.withZoneUTC());
            }

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parsedDate = formatter.parseDateTime(dateStr);
                            return parsedDate;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 14.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof DateTime) {
                    DateTime date = (DateTime)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)date.toDateTime());
                    repr.mapPutString("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.JAVAUTILDATE){
            final List<DateTimeFormatter> formatters;
            {
                this.formatters = Arrays.asList(ISODateTimeFormat.dateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.dateTime().withZoneUTC(), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicDateTime().withZoneUTC(), JsonRepresentation.yyyyMMddTHHmmssZ.withZoneUTC());
            }

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parseDateTime = formatter.parseDateTime(dateStr);
                            java.util.Date parsedDate = parseDateTime.toDate();
                            return parsedDate;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 15.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)obj;
                    DateTimeFormatter dateTimeFormatter = this.formatters.get(0);
                    String dateStr = dateTimeFormatter.print((ReadableInstant)new DateTime((Object)date));
                    repr.mapPutString("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.JAVASQLDATE){
            final List<DateTimeFormatter> formatters;
            {
                this.formatters = Arrays.asList(ISODateTimeFormat.date().withZoneUTC(), ISODateTimeFormat.basicDate().withZoneUTC(), JsonRepresentation.yyyyMMdd.withZoneUTC());
            }

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parseDateTime = formatter.parseDateTime(dateStr);
                            Date parsedDate = new Date(parseDateTime.getMillis());
                            return parsedDate;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 16.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Date) {
                    Date date = (Date)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)new DateTime((Object)date));
                    repr.mapPutString("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.JAVASQLTIME){
            final List<DateTimeFormatter> formatters;
            {
                this.formatters = Arrays.asList(ISODateTimeFormat.hourMinuteSecond().withZoneUTC(), ISODateTimeFormat.basicTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicTime().withZoneUTC(), JsonRepresentation._HHmmss.withZoneUTC());
            }

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parseDateTime = formatter.parseDateTime(dateStr);
                            Time parsedTime = new Time(parseDateTime.getMillis());
                            return parsedTime;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 17.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Time) {
                    Time date = (Time)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)new DateTime((Object)date));
                    repr.mapPutString("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        converters.add(new JsonValueConverter.Abstract(DefaultFormat.JAVASQLTIMESTAMP){

            @Override
            public Object recoverValueAsPojo(JsonRepresentation repr, JsonValueConverter.Context context) {
                if (repr.isLong()) {
                    Long millis = repr.asLong();
                    Timestamp parsedTimestamp = new Timestamp(millis);
                    return parsedTimestamp;
                }
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    try {
                        Long parseMillis = Long.parseLong(dateStr);
                        Timestamp parsedTimestamp = new Timestamp(parseMillis);
                        return parsedTimestamp;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, JsonValueConverter.Context context, JsonRepresentation repr) {
                Object obj = 18.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Timestamp) {
                    Timestamp date = (Timestamp)obj;
                    long millisStr = date.getTime();
                    repr.mapPutLong("value", millisStr);
                } else {
                    repr.mapPut("value", obj);
                }
                this.appendFormats(repr, context);
                return obj;
            }
        });
        return converters;
    }

    public static enum DefaultFormat {
        STRING(String.class, null, "string"),
        BOOLEAN(Boolean.class, null, "boolean"),
        BYTE(Byte.class, "int", "byte"),
        SHORT(Short.class, "int", "short"),
        INT(Integer.class, "int", "int"),
        LONG(Long.class, "int", "long"),
        FLOAT(Float.class, "decimal", "float"),
        DOUBLE(Double.class, "decimal", "double"),
        CHAR(Character.class, null, "char"),
        BIGINTEGER(BigInteger.class, "big-integer(18)", "javamathbiginteger"),
        BIGDECIMAL(BigDecimal.class, "big-decimal", "javamathbigdecimal"),
        JODALOCALDATE(LocalDate.class, "date", "jodalocaldate"),
        JODALOCALDATETIME(LocalDateTime.class, "date-time", "jodalocaldatetime"),
        JODADATETIME(DateTime.class, "date-time", "jodadatetime"),
        JAVAUTILDATE(java.util.Date.class, "date-time", "javautildate"),
        JAVASQLDATE(Date.class, "date", "javasqldate"),
        JAVASQLTIME(Time.class, "time", "javasqltime"),
        JAVASQLTIMESTAMP(Timestamp.class, "utc-millisec", "javasqltimestamp");

        final Class<?> valueClass;
        final String format;
        final String extendedFormat;

        private DefaultFormat(Class<?> valueClass, String format, String extendedFormat) {
            this.valueClass = valueClass;
            this.format = format;
            this.extendedFormat = extendedFormat;
        }
    }
}

