/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domaintypes;

import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.AbstractTypeMemberReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;

public class PropertyDescriptionReprRenderer
extends AbstractTypeMemberReprRenderer<OneToOneAssociation> {
    public static LinkBuilder newLinkToBuilder(IResourceContext resourceContext, Rel rel, ObjectSpecification objectSpecification, OneToOneAssociation property) {
        String domainType = objectSpecification.getLogicalTypeName();
        String propertyId = property.getId();
        String url = "domain-types/" + domainType + "/properties/" + propertyId;
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.PROPERTY_DESCRIPTION, url, new Object[0]);
    }

    public PropertyDescriptionReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.PROPERTY_DESCRIPTION, representation);
    }

    @Override
    protected void addLinksSpecificToFeature() {
        this.addLinkToReturnTypeIfAny();
    }

    @Override
    protected void addPropertiesSpecificToFeature() {
        this.representation.mapPutBoolean("optional", !((OneToOneAssociation)this.getObjectFeature()).isMandatory());
        Facets.maxLength(this.getObjectFeature()).ifPresent(maxLength -> this.representation.mapPutInt("maxLength", maxLength));
    }

    @Override
    protected void putExtensionsSpecificToFeature() {
        this.putExtensionsName();
        this.putExtensionsDescriptionIfAvailable();
    }

    private void addLinkToReturnTypeIfAny() {
        ObjectSpecification returnTypeSpec = ((OneToOneAssociation)this.getObjectFeature()).getElementType();
        if (returnTypeSpec == null) {
            return;
        }
        this.getLinks().arrayAdd(DomainTypeReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.RETURN_TYPE, returnTypeSpec).build());
    }
}

