/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domainobjects;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.DomainObjectLinkTo;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;

public class ListReprRenderer
extends ReprRendererAbstract<Stream<ManagedObject>> {
    private ObjectAdapterLinkTo linkTo;
    private List<ManagedObject> objectAdapters;
    private ObjectSpecification elementType;
    private ObjectSpecification returnType;
    private Rel elementRel;

    public ListReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.LIST, representation);
        this.usingLinkToBuilder(new DomainObjectLinkTo());
    }

    public ListReprRenderer usingLinkToBuilder(ObjectAdapterLinkTo objectAdapterLinkToBuilder) {
        this.linkTo = objectAdapterLinkToBuilder.usingUrlBase(this.resourceContext);
        return this;
    }

    public ListReprRenderer with(Stream<ManagedObject> objectAdapters) {
        this.objectAdapters = objectAdapters != null ? objectAdapters.filter(adapter -> !adapter.objSpec().isHidden()).collect(Collectors.toList()) : null;
        return this;
    }

    public ListReprRenderer withElementRel(Rel elementRel) {
        this.elementRel = elementRel;
        return this;
    }

    public ListReprRenderer withReturnType(ObjectSpecification returnType) {
        this.returnType = returnType;
        return this;
    }

    public ListReprRenderer withElementType(ObjectSpecification elementType) {
        this.elementType = elementType;
        return this;
    }

    @Override
    public JsonRepresentation render() {
        if (this.representation == null) {
            return null;
        }
        this.addValue();
        this.addLinkToReturnType();
        this.addLinkToElementType();
        this.getExtensions();
        return this.representation;
    }

    private void addValue() {
        if (this.objectAdapters == null) {
            return;
        }
        JsonRepresentation values = JsonRepresentation.newArray();
        this.objectAdapters.forEach(adapter -> {
            JsonRepresentation linkToObject = this.linkTo.with((ManagedObject)adapter).builder(this.elementRel).build();
            values.arrayAdd(linkToObject);
            LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("value", new Object[0]);
            if (linkFollower.matches(linkToObject)) {
                DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
                JsonRepresentation domainObject = renderer.with((ManagedObject)adapter).render();
                linkToObject.mapPutJsonRepresentation("value", domainObject);
            }
        });
        this.representation.mapPutJsonRepresentation("value", values);
    }

    protected void addLinkToReturnType() {
        this.addLink(Rel.RETURN_TYPE, this.returnType);
    }

    protected void addLinkToElementType() {
        this.addLink(Rel.ELEMENT_TYPE, this.elementType);
    }
}

