/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domaintypes;

import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.ReprRendererAbstract;

public class TypeListReprRenderer
extends ReprRendererAbstract<Can<? extends ObjectSpecification>> {
    private Can<? extends ObjectSpecification> specifications;

    public TypeListReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.TYPE_LIST, representation);
    }

    public TypeListReprRenderer with(Can<? extends ObjectSpecification> specifications) {
        this.specifications = specifications;
        return this;
    }

    @Override
    public JsonRepresentation render() {
        if (this.includesSelf) {
            this.withLink(Rel.SELF, "domain-types");
        }
        JsonRepresentation specList = JsonRepresentation.newArray();
        for (ObjectSpecification objectSpec : this.specifications) {
            LinkBuilder linkBuilder = LinkBuilder.newBuilder(this.getResourceContext(), Rel.DOMAIN_TYPE.getName(), RepresentationType.DOMAIN_TYPE, "domain-types/%s", objectSpec.logicalTypeName());
            specList.arrayAdd(linkBuilder.build());
        }
        this.representation.mapPutJsonRepresentation("values", specList);
        this.getExtensions();
        return this.representation;
    }
}

